package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.newSupplier.SupplierGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.newSupplier.SupplierItemExtraDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.supplier.SupplierDTO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteSupplierGoodsService {
	/**
	 * 获取供应商商品
	 * @return
     */
	List<SupplierGoodsDto> findBySupplierSkuId(List<Long> skuIds);

	/**
	 * 创建供应商商品
	 * @return
	 */
	Boolean createItem(List<SupplierDTO> supplierDTOS) throws Exception;

	/**
	 * 修改商品
	 * @param supplierDTOS
	 * @return
	 * @throws Exception
	 */
	Boolean updateItem(List<SupplierDTO> supplierDTOS) throws Exception;

	/**
	 * 删除商品
	 * @param itemIds
	 * @return
	 */
	Boolean deleteItems(List<Long> itemIds) throws Exception;

	/**
	 * 供应商商品扩展信息
	 * @param itemIds
	 * @return
	 */
	List<SupplierItemExtraDto> selectSupplierItemExtra(List<Long> itemIds) throws BizException;
}
