package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;
import java.util.Date;

/**
 * @Desc: 卡券库
 * @Author: xuwei
 * @Date: 2018/11/27 14:28
 */
public class CardLibraryDto implements Serializable {
    private static final long serialVersionUID = -4699123598764702147L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 兑吧商品id
     */
    private Long itemId;

    /**
     * 自有商品id
     */
    private Long appItemId;

    /**
     * skuid
     */
    private Long skuId;

    /**
     * appid
     */
    private Long appId;

    /**
     * 名称
     */
    private String name;

    /**
     * 类型：1券码；2:卡密
     */
    private Integer type;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 过期时间
     */
    private Date expiredDate;

    //剩余库存
    private Long stock;

    //总库存
    private Long totalStock;

    /**
     * 创建人id
     */
    private Long createId;

    /**
     * 创建人姓名
     */
    private String createName;

    //卡券库类型，0:普通卡券, 1:总卡券库
    private Integer cardLibraryType;

    /**
     * 卡券来源 0-兑吧 1-供应商
     * {@link cn.com.duiba.goods.center.api.remoteservice.enums.CardLibrarySourceEnum}
     */
    private Integer cardSource;

    /**
     * 供应商商品Id
     */
    private Long supplierGoodsId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getExpiredDate() {
        return expiredDate;
    }

    public void setExpiredDate(Date expiredDate) {
        this.expiredDate = expiredDate;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    public Long getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Long totalStock) {
        this.totalStock = totalStock;
    }

    public Long getCreateId() {
        return createId;
    }

    public void setCreateId(Long createId) {
        this.createId = createId;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Integer getCardLibraryType() {
        return cardLibraryType;
    }

    public void setCardLibraryType(Integer cardLibraryType) {
        this.cardLibraryType = cardLibraryType;
    }

    public Integer getCardSource() {
        return cardSource;
    }

    public void setCardSource(Integer cardSource) {
        this.cardSource = cardSource;
    }

    public Long getSupplierGoodsId() {
        return supplierGoodsId;
    }

    public void setSupplierGoodsId(Long supplierGoodsId) {
        this.supplierGoodsId = supplierGoodsId;
    }
}