package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * banner活动类型枚举
 */
public enum BannerActivityTypeEnum {

    DUIBA_ACTIVITY("duibaActivity", "专题活动"),
    DUIBA_SINGLE_LOTTERY("duibaSingleLottery", "单品抽奖"),
    DUIBA_HDTOOL("duibaHdtool", "活动工具"),
    DUIBA_SECONDS_KILL_ACTIVITY("duibaSecondsKillActivity", "秒杀专题"),
    DUIBA_QUESTION_ANSWER("duibaQuestionAnswer", "答题"),
    DUIBA_QUIZZ("duibaQuizz", "测试题"),
    DUIBA_SECKILL("duibaSeckill", "秒杀活动"),
    DUIBA_NGAME("duibaNgame", "新游戏"),
    DUIBA_GUESS("duibaGuess", "竞猜");

    private String value;
    private String desc;

    BannerActivityTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public static BannerActivityTypeEnum fromValue(String value) {
        for (BannerActivityTypeEnum it : BannerActivityTypeEnum.values()) {
            if (value.equals(it.value())) {
                return it;
            }
        }
        return null;
    }
}
