package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.api.bo.KeyValueEntity;
import cn.com.duiba.goods.center.api.remoteservice.dto.marketing.MarketingItemCreditsSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AppItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.CreditsSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.ExchangeTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteItemNewExtraService;
import cn.hutool.core.util.BooleanUtil;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * Created by sunyan on 2018/11/12.
 */
public class MarketingSkuUtils {

    private static final String SEPARATOR_ATTRIBUTE_SEMICOLON = ";";
    private static final String SEPARATOR_ATTRIBUTE_COLON = ":";

    @Autowired
    private RemoteItemNewExtraService remoteItemNewExtraService;

    /**
     * web用积分兑换商品sku信息
     *
     * @param skuList
     * @param marketingItemCreditsSkuList
     * @param exchangeType
     * @param creditsRate
     * @return
     */
    public static List<CreditsSkuDto> getCreditsSkuList(List<AppItemSkuDto> skuList, List<MarketingItemCreditsSkuDto> marketingItemCreditsSkuList, Integer exchangeType, Integer creditsRate) {
        if (null == skuList || skuList.isEmpty() || null == exchangeType) {
            return null;
        }
        List newSkuList = Lists.newArrayList();
        Map<Long, MarketingItemCreditsSkuDto> marketingItemCreditsSkuMap = new HashMap<>();
        if (marketingItemCreditsSkuList != null && !marketingItemCreditsSkuList.isEmpty()) {
            marketingItemCreditsSkuMap = marketingItemCreditsSkuList.stream().collect(Collectors.toMap(MarketingItemCreditsSkuDto::getSkuId, m -> m, (k1, k2) -> k1));
        }

        for (AppItemSkuDto sku : skuList) {
            if (sku.getSaleStatus() != null && sku.getSaleStatus().intValue() == 0) {//过滤不可售
                continue;
            }
            CreditsSkuDto skuObj = new CreditsSkuDto();
            skuObj.setSkuId(sku.getId());
            skuObj.setAttributeValue(getAttributeValue(sku.getAttributeJson()));
            skuObj.setFacePrice(sku.getFacePrice());
            skuObj.setSalePrice(sku.getSalePrice());
            skuObj.setImgUrl(sku.getImgUrl());
            skuObj.setRemaining(sku.getRemaining());
            skuObj.setTotalStock(sku.getTotalStock());
            skuObj.setStartDay(sku.getStartDay());
            skuObj.setEndDay(sku.getEndDay());
            skuObj.setCurrentStock(sku.getCurrentStock());
            skuObj.setCurrentTotalStock(sku.getCurrentTotalStock());
            skuObj.setCostPrice(sku.getCostPrice());

            //积分兑换信息
            setMarketingInfo(exchangeType, creditsRate, marketingItemCreditsSkuMap, sku, skuObj);
            newSkuList.add(skuObj);
        }
        return newSkuList;
    }

    public static String getAttributeValue(String attributeJson) {
        if (StringUtils.isBlank(attributeJson)) {
            return null;
        }
        /** 属性数组 [1:2:深黄,2:23:XXL] */
        String[] attrArray = attributeJson.split(SEPARATOR_ATTRIBUTE_SEMICOLON);
        StringBuilder newSkuStr = new StringBuilder();
        /**
         * 处理属性信息，去除用户自定义属性
         * 因用户自定义属性，不参与匹配sku信息
         */
        for (String attrStr : attrArray) {
            /** 判断属性分隔符":"是否存在第二个存在即表示：含有用户自定义属性*/
            Integer i = attrStr.indexOf(SEPARATOR_ATTRIBUTE_COLON, attrStr.indexOf(SEPARATOR_ATTRIBUTE_COLON) + 1);
            String newValue;
            if (i != -1) {
                newValue = attrStr.substring(0, attrStr.lastIndexOf(SEPARATOR_ATTRIBUTE_COLON));
            } else {
                newValue = attrStr;
            }
            newSkuStr.append(newValue).append(SEPARATOR_ATTRIBUTE_SEMICOLON);
        }
        return newSkuStr.toString().substring(0, newSkuStr.length() - 1);
    }

    private static void setMarketingInfo(Integer exchangeType, Integer creditsRate, Map<Long, MarketingItemCreditsSkuDto> marketingItemCreditsSkuMap, AppItemSkuDto sku, CreditsSkuDto skuObj) {
        if (exchangeType.intValue() == ExchangeTypeEnum.AUTOMATIC.getCode().intValue()) {//自动转换
            skuObj.setMarketingCredits((long) Math.ceil(sku.getSalePrice() * (long) creditsRate / 100.0));
            skuObj.setMarketingPrice(0L);
            skuObj.setConfigPureCredits((long) Math.ceil(sku.getSalePrice() * (long) creditsRate / 100.0));
        } else {
            MarketingItemCreditsSkuDto dto = marketingItemCreditsSkuMap.get(sku.getId());
            skuObj.setMarketingCredits(dto.getCustomCredits());
            skuObj.setMarketingPrice(dto.getCustomPrice());
            skuObj.setConfigPureCredits(dto.getConfigPureCredits());
        }
    }

    public static List<CreditsSkuDto> getBeiJingXianDaiCustomizedCreditsSkuList(List<AppItemSkuDto> skuList, List<MarketingItemCreditsSkuDto> marketingItemCreditsSkuList, Integer exchangeType, Integer creditsRate, Boolean carBind, Boolean nonOwnerSwOrigPriceBuy) {
        if (null == skuList || skuList.isEmpty() || null == exchangeType) {
            return null;
        }
        List newSkuList = Lists.newArrayList();
        Map<Long, MarketingItemCreditsSkuDto> marketingItemCreditsSkuMap = new HashMap<>();
        if (marketingItemCreditsSkuList != null && !marketingItemCreditsSkuList.isEmpty()) {
            marketingItemCreditsSkuMap = marketingItemCreditsSkuList.stream().collect(Collectors.toMap(MarketingItemCreditsSkuDto::getSkuId, m -> m, (k1, k2) -> k1));
        }

        for (AppItemSkuDto sku : skuList) {
            if (sku.getSaleStatus() != null && sku.getSaleStatus().intValue() == 0) {//过滤不可售
                continue;
            }
            CreditsSkuDto skuObj = new CreditsSkuDto();
            skuObj.setSkuId(sku.getId());
            skuObj.setAttributeValue(getAttributeValue(sku.getAttributeJson()));
            skuObj.setFacePrice(sku.getFacePrice());
            skuObj.setSalePrice(sku.getSalePrice());
            skuObj.setImgUrl(sku.getImgUrl());
            skuObj.setRemaining(sku.getRemaining());
            skuObj.setTotalStock(sku.getTotalStock());
            skuObj.setStartDay(sku.getStartDay());
            skuObj.setEndDay(sku.getEndDay());
            skuObj.setCurrentStock(sku.getCurrentStock());
            skuObj.setCurrentTotalStock(sku.getCurrentTotalStock());
            skuObj.setCostPrice(sku.getCostPrice());

            //积分兑换信息
            setBeiJingXianDaiCustomizedMarketingInfo(exchangeType, creditsRate, marketingItemCreditsSkuMap, sku, skuObj, carBind, nonOwnerSwOrigPriceBuy);
            newSkuList.add(skuObj);
        }
        return newSkuList;
    }

    private static void setBeiJingXianDaiCustomizedMarketingInfo(Integer exchangeType, Integer creditsRate, Map<Long, MarketingItemCreditsSkuDto> marketingItemCreditsSkuMap, AppItemSkuDto sku, CreditsSkuDto skuObj, Boolean carBind, Boolean nonOwnerSwOrigPriceBuy) {
        //非车主 并且勾选非车主用户自动切换原价购买
        if (carBind != null && !carBind && nonOwnerSwOrigPriceBuy) {
            if (exchangeType.intValue() == ExchangeTypeEnum.AUTOMATIC.getCode().intValue()) {
                MarketingItemCreditsSkuDto dto = marketingItemCreditsSkuMap.get(sku.getId());
                if(dto == null){
                    skuObj.setMarketingCredits(0L);
                    skuObj.setMarketingPrice(sku.getSalePrice());
                    skuObj.setConfigPureCredits((long) Math.ceil(sku.getSalePrice() * (long) creditsRate / 100.0));
                } else {
                    skuObj.setMarketingCredits(dto.getCustomCredits());
                    skuObj.setMarketingPrice(dto.getCustomPrice());
                    skuObj.setConfigPureCredits(dto.getConfigPureCredits());
                }
            }
        } else if (exchangeType.intValue() == ExchangeTypeEnum.AUTOMATIC.getCode().intValue()) {//自动转换
            skuObj.setMarketingCredits((long) Math.ceil(sku.getSalePrice() * (long) creditsRate / 100.0));
            skuObj.setMarketingPrice(0L);
            skuObj.setConfigPureCredits((long) Math.ceil(sku.getSalePrice() * (long) creditsRate / 100.0));
        } else {
            MarketingItemCreditsSkuDto dto = marketingItemCreditsSkuMap.get(sku.getId());
            skuObj.setMarketingCredits(dto.getCustomCredits());
            skuObj.setMarketingPrice(dto.getCustomPrice());
            skuObj.setConfigPureCredits(dto.getConfigPureCredits());
        }
    }
}
