package cn.com.duiba.goods.center.api.remoteservice.tool;


import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemExtraDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.PriceDegreeDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.ItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.ItemMarkEnum;
import cn.com.duiba.goods.center.api.remoteservice.enums.VisualItemChannelEnum;
import cn.com.duiba.wolf.utils.DateUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import java.util.Calendar;
import java.util.Date;

/**
 * 开发者，兑吧商品工具类
 */
public class ItemKeyUtils {
    public static final Long CURRENT_ITEM_VERSION = 1L;

	private ItemKeyUtils(){
		
	}
	
	/**
	 * 是否是商品中心优惠券
	 * @param itemKeyDto
	 * @return
	 */
	public static boolean isGoodsCoupon(ItemKeyDto itemKeyDto) {
        if(itemKeyDto.isV1()){
            return true;
        }
		if (itemKeyDto.isSelfAppItemMode()) {
			return itemKeyDto.getAppItem().isOpTypeAppItem(ItemDto.OpTypeGoodsCoupon);
		}
		if (itemKeyDto.isItemMode() || itemKeyDto.isDuibaAppItemMode()) {
			return itemKeyDto.getItem().isOpTypeItem(ItemDto.OpTypeGoodsCoupon);
		}
		return false;
	}
	
	/**
	 * 获取有效的Id
	 * @param itemKey
	 * @return
	 */
    public static Long getId(ItemKeyDto itemKey){
        if(itemKey.getAppItem()!=null){
            if(itemKey.getAppItem().getId()==null){
                if (itemKey.getItem() != null) {
                    return itemKey.getItem().getId();
                }
                return null;
            }else{
                return itemKey.getAppItem().getId();
            }
        }else{
            return itemKey.getItem().getId();
        }
    }

    /**
     * 获取商品类型
     * @param itemKey
     * @return
     */
    public static String getType(ItemKeyDto itemKey){
        if(itemKey.getAppItem()!=null){
            if(itemKey.getAppItem().getType()==null){
                if (itemKey.getItem() != null) {
                    return itemKey.getItem().getType();
                }
                return null;
            }else{
                return itemKey.getAppItem().getType();
            }
        }else{
            return itemKey.getItem().getType();
        }
    }


    /**
     * 获取商品名称
     * @param itemKey
     * @return
     */
    public static String getName(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getName();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getTitle();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getTitle())) {
                return itemKey.getAppItem().getTitle();
            } else {
                return itemKey.getItem().getName();
            }
        }
        return null;
    }
    /**
     * 获取子标题
     * @param itemKey
     * @return
     */
    public static String getSubtitle(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getSubtitle();
        } else if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isBlank(itemKey.getAppItem().getSubtitle())) {
                return itemKey.getItem().getSubtitle();
            } else {
                return itemKey.getAppItem().getSubtitle();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getSubtitle();
        } else {
            return null;
        }
    }

    /**
     * getTitle
     * @param itemKey
     * @return
     */
    public static String getTitle(ItemKeyDto itemKey){
        if(itemKey.getAppItem()!=null){
            if(itemKey.getAppItem().getTitle()==null){
                if (itemKey.getItem() != null) {
                    return itemKey.getItem().getName();
                }
                return null;
            }else{
                return itemKey.getAppItem().getTitle();
            }
        }else{
            return itemKey.getItem().getName();
        }
    }

    /**
     * 获取商品图片
     * @param itemKey
     * @return
     */
    public static String getImage(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getImage();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getImage();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getLogo())) {
                return itemKey.getAppItem().getImage();
            } else {
                return itemKey.getItem().getImage();
            }
        }
        return null;
    }

    /**
     * getLogo
     * @param itemKey
     * @return
     */
    public static String getLogo(ItemKeyDto itemKey){
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getLogo();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getLogo();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getLogo())) {
                return itemKey.getAppItem().getLogo();
            } else {
                return itemKey.getItem().getLogo();
            }
        }
        return null;
    }

	/**
	 * 按图片风格获取缩略图
	 * 
	 * @param itemKey
	 * @param imageStyle
	 * @return
	 */
    public static String getThumbnailImage(ItemKeyDto itemKey,Integer imageStyle) {
        return getThumbnailImage(itemKey.getAppItem(),itemKey.getItem(),imageStyle);
    }

    /**
     * getThumbnailImage
     * @param appItem
     * @param item
     * @param imageStyle
     * @return
     */
    public static String getThumbnailImage(AppItemDto appItem, ItemDto item, Integer imageStyle) {
        String smallImage = "";
        String whiteImage = "";
        if(item!=null && appItem==null){//兑吧模式
            smallImage = item.getSmallImage();
            whiteImage = item.getWhiteImage();
        }
        if(item!=null && appItem!=null){
            smallImage = StringUtils.isNotBlank(appItem.getSmallImage())?appItem.getSmallImage():item.getSmallImage();
            whiteImage = StringUtils.isNotBlank(appItem.getWhiteImage())?appItem.getWhiteImage():item.getWhiteImage();
        }
        if(item==null && appItem!=null){
            smallImage = appItem.getSmallImage();
            whiteImage = appItem.getWhiteImage();
        }
        return getThumbnailImage(smallImage, whiteImage, imageStyle);
    }

    /**
     * getThumbnailImage
     * @param smallImage
     * @param whiteImage
     * @param imageStyle
     * @return
     */
    public static String getThumbnailImage(String smallImage, String whiteImage,Integer imageStyle) {
        String image = "";
        if(imageStyle==0){
            image = StringUtils.isNotBlank(smallImage)?smallImage:whiteImage;
        }
        if(imageStyle==1){
            image = StringUtils.isNotBlank(whiteImage)?whiteImage:smallImage;
        }
        return StringUtils.isNotBlank(image)?image:"//yun.duiba.com.cn/developer/img/default_img.jpg";
    }

    /**
     * 获取缩略图
     * @param itemKey
     * @return
     */
    public static String getSmallImage(ItemKeyDto itemKey){
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getSmallImage();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getSmallImage();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getSmallImage())) {
                return itemKey.getAppItem().getSmallImage();
            } else {
                return itemKey.getItem().getSmallImage();
            }
        }
        return null;
    }

    /**
     * 获取新版缩略图链接
     *
     * @param itemKey
     * @return smallImageNew
     */
    public static String getSmallImageNew(ItemKeyDto itemKey) {
        String smallImageNew = null;
        ItemExtraDto itemExtra = itemKey.getItem() == null ? null : itemKey.getItem().getItemExtraDto();
        String extraSmallNew = itemExtra == null ? null : itemExtra.getSmallImgNew();
        if (itemKey.isItemMode()) {// 兑吧模式
            smallImageNew = extraSmallNew;
        }
        if (itemKey.isSelfAppItemMode()) {
            smallImageNew = itemKey.getAppItem().getSmallImgNew();
        }
        if (itemKey.isDuibaAppItemMode()) {
            smallImageNew = itemKey.getAppItem().getSmallImgNew();
            smallImageNew = StringUtils.isNotBlank(smallImageNew) ? smallImageNew : extraSmallNew;
        }

        return StringUtils.isNotBlank(smallImageNew) ? smallImageNew : null;
    }

    /**
     * 获取banner图链接
     *
     * @param itemKey
     * @return BannerImage
     */
    public static String getBannerImage(ItemKeyDto itemKey) {
        String bannerImage = null;
        if (itemKey.isItemMode()) {// 兑吧模式
            bannerImage = itemKey.getItem().getBannerImage();
        }
        if (itemKey.isSelfAppItemMode()) {
            bannerImage = itemKey.getAppItem().getBannerImage();
        }
        if (itemKey.isDuibaAppItemMode()) {
            bannerImage = StringUtils.isNotBlank(itemKey.getAppItem().getBannerImage()) ? itemKey.getAppItem().getBannerImage() : itemKey.getItem().getBannerImage();
        }

        return StringUtils.isNotBlank(bannerImage) ? bannerImage : null;
    }

    /**
     * 获取新版banner图链接
     *
     * @param itemKey
     * @return bannerImageNew
     */
    public static String getBannerImageNew(ItemKeyDto itemKey) {
        String bannerImageNew = null;
        ItemExtraDto itemExtra = itemKey.getItem() == null ? null : itemKey.getItem().getItemExtraDto();
        String extraBannerNew = itemExtra == null ? null : itemExtra.getBannerImgNew();
        if (itemKey.isItemMode()) {// 兑吧模式
            bannerImageNew = extraBannerNew;
        }
        if (itemKey.isSelfAppItemMode()) {
            bannerImageNew = itemKey.getAppItem().getBannerImgNew();
        }
        if (itemKey.isDuibaAppItemMode()) {
            bannerImageNew = itemKey.getAppItem().getBannerImgNew();
            bannerImageNew = StringUtils.isNotBlank(bannerImageNew) ? bannerImageNew : extraBannerNew;
        }

        return StringUtils.isNotBlank(bannerImageNew) ? bannerImageNew : null;
    }

    /**
     * 获取商品描述信息
     * @param itemKey
     * @return
     */
    public static String getDescription(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            return itemKey.getItem().getDescription();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getDescription();
        }
        return null;
    }
    /**
     * 获取价格
     * @param itemKey
     * @return
     */
    public static Double getPrice(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().getMarketPrice() != null) {
                return itemKey.getItem().getMarketPrice() / 100.0;
            }
            return itemKey.getItem().getFacePrice() / 100.0;
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getFacePrice() / 100.0;
        }
        return null;
    }


    public static String getStringItemKey(ItemKeyDto itemKey){
        Long itemId = itemKey.getItem()!=null?itemKey.getItem().getId():null;
        Long appItemId = itemKey.getAppItem()!=null?itemKey.getAppItem().getId():null;
        return getStringItemKey(itemId,appItemId);
    }

    public static String getStringItemKey(Long itemId, Long appItemId){
        String devItemId = appItemId == null ? "" : String.valueOf(appItemId);
        String duibaItemId = itemId == null ? "" : String.valueOf(itemId);
        StringBuilder sb = new StringBuilder();
        sb.append(devItemId).append("_").append(duibaItemId);
        return sb.toString();
    }


    /**
     * getSalePrice
     * @param itemKey
     * @return
     */
    public static Long getSalePrice(ItemKeyDto itemKey){
        if (itemKey.isItemMode() && null != itemKey.getItem().getSalePrice()) {
            return itemKey.getItem().getSalePrice();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if(null != itemKey.getAppItem().getSalePrice()) {
                return itemKey.getAppItem().getSalePrice();
            } else if(null != itemKey.getItem().getSalePrice()) {
                return itemKey.getItem().getSalePrice();
            }
        }
        if (itemKey.isSelfAppItemMode() && null != itemKey.getAppItem().getSalePrice()) {
            return itemKey.getAppItem().getSalePrice();
        }
        return null;
    }

    /**
     * 获取商品角标
     * @param itemKey
     * @return
     */
    public static ItemMarkEnum getMarkType(ItemKeyDto itemKey){
    	if (itemKey.isDuibaAppItemMode()) {
            // 秒杀（限时）
            if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeTimeLimit) || itemKey.getItem().isOpTypeItem(ItemDto.OpTypeTimeLimit)) {
                return ItemMarkEnum.MARK_TIME;
                // 地域限制
            }

            if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeAddrLimit) || itemKey.getItem().isOpTypeItem(ItemDto.OpTypeAddrLimit)) {
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
        }else if (itemKey.isItemMode()) {
            // 秒杀（限时）
            if (itemKey.getItem().isOpTypeItem(ItemDto.OpTypeTimeLimit)) {
                return ItemMarkEnum.MARK_TIME;
                // 地域限制
            }

            if (itemKey.getItem().isOpTypeItem(ItemDto.OpTypeAddrLimit)) {
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
        }else if (itemKey.isSelfAppItemMode()) {
            ItemMarkEnum itemMarkEnum = getItemMarkEnum(itemKey);
            if (itemMarkEnum != null) {
                return itemMarkEnum;
            }
        }
        return ItemMarkEnum.MARK_NORMAL;
    }

    private static ItemMarkEnum getItemMarkEnum(ItemKeyDto itemKey) {
        if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeAddrLimit)) {
            //地域限制
            return ItemMarkEnum.MARK_ADDRLIMIT;
        }

        if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeTimeLimit)) {
            // 秒杀（限时）
            return ItemMarkEnum.MARK_TIME;
        }

        if (itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeSingleLottery
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeOperatingActivity
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeManualLottery
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeAppShakeLottery
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeHdtoolTiger
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeHdtoolTurntable
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameSanta
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameYearAward
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameGirl
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameJiong
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeDuibaQuestionAnswer
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeDuibaQuizz
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeNgame
                  || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGuess) {
            // 抽奖
            return ItemMarkEnum.MARK_LOTTERY;
        }
        return null;
    }

    /**
     * @param itemKey
     * @param opType
     * @return 是否开启开关
     */
    public static boolean isOpTypeSwitchOn(ItemKeyDto itemKey, int opType){
        if(itemKey.getAppItem() != null){
            return itemKey.getAppItem().isOpTypeAppItem(opType);
        }

        if(itemKey.getItem() !=  null){
            return itemKey.getItem().isOpTypeItem(opType);
        }
        return false;
    }

    public static Long getItemId(ItemKeyDto itemKey){
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            return itemKey.getItem().getId();
        }
        if (itemKey.isSelfAppItemMode()) {
            return null;
        }
        return null;
    }

    public static Long getAppItemId(ItemKeyDto itemKey){
        if (itemKey.isItemMode()) {
            return null;
        }
        if (itemKey.isSelfAppItemMode() || itemKey.isDuibaAppItemMode()) {
            return itemKey.getAppItem().getId();
        }
        return null;
    }


    /**
     * 判断是否是开发者自有秒杀商品
     *
     * @param itemKey
     * @return Tuple
     */
    public static boolean isSeckillAppItem(ItemKeyDto itemKey) {
        if (itemKey==null||!itemKey.isSelfAppItemMode()) {
            return false;
        }
        // 限时限量
        return itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeTimeLimit);
    }


    /**
     * 判断是否是开发者自有秒杀商品
     *
     * @param appItemDto
     * @return Tuple
     */
    public static boolean isSeckillAppItem(AppItemDto appItemDto) {
        if (appItemDto == null) {
            return false;
        }
        // 限时限量
        return appItemDto.isOpTypeAppItem(ItemDto.OpTypeTimeLimit);
    }

    /**
     * 解析商品限期与限时字段
     * @param itemKey
     * @return
     */
    public static DateEntry getLimitDateEntry(ItemKeyDto itemKey) {
        DateEntry dateEntry = new DateEntry();
        String limitDate = getLimitDate(itemKey);

        if (StringUtils.isNotBlank(limitDate) && !"no".equals(limitDate)) {
            String[] dayBetween = StringUtils.split(limitDate, ',');
            Calendar cal = Calendar.getInstance();
            Date dateTemp;
            if(StringUtils.isNotBlank(dayBetween[0]) && (dateTemp = DateUtils.getDayDate(dayBetween[0])) != null) {
                cal.setTime(dateTemp);
                dateEntry.setStartDay(cal.getTime());
            }
            if (dayBetween.length == 2 && StringUtils.isNotBlank(dayBetween[1])) {
                if((dateTemp = DateUtils.getDayDate(dayBetween[1])) != null) {
                    cal.setTime(dateTemp);
                    dateEntry.setEndDay(cal.getTime());
                }
            }
        }
        if (itemKey.getAppItem() != null && StringUtils.isNotBlank(itemKey.getAppItem().getLimitTimeBetween())
                && !"no".equals(itemKey.getAppItem().getLimitTimeBetween())) {
            String[] limitTimes = itemKey.getAppItem().getLimitTimeBetween().split("-");
            if (limitTimes.length == 2) {
                dateEntry.setStartTime(limitTimes[0]);
                dateEntry.setEndTime(limitTimes[1]);
            }
        }
        return dateEntry;
    }

    public static String getLimitDate(ItemKeyDto itemKey){
        String limitDate = null;
        if (itemKey.isItemMode()) {
            limitDate = itemKey.getItem().getLimitDate();
        } else if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().getLimitDate() != null && !StringUtils.equals(itemKey.getItem().getLimitDate(), "no")) {
                limitDate = itemKey.getItem().getLimitDate();
            } else if (itemKey.getAppItem().getLimitDate() != null) {
                limitDate = itemKey.getAppItem().getLimitDate();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            limitDate = itemKey.getAppItem().getLimitDate();
        }
        return limitDate;
    }

    public static String getLimitScope(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getLimitScope();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getLimitScope();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (StringUtils.isNotBlank(itemKey.getAppItem().getLimitScope())) {
                return itemKey.getAppItem().getLimitScope();
            } else {
                return itemKey.getItem().getLimitScope();
            }
        }
        return null;
    }

    public static Integer getLimitCount(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().getLimitCount();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getLimitCount();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getAppItem().getLimitCount() != null) {
                return itemKey.getAppItem().getLimitCount();
            } else {
                return itemKey.getItem().getLimitCount();
            }
        }
        return null;
    }


    /**
     * 判断是否是多档位商品
     * @param itemKeyDto
     * @return
     */
    public static boolean getMultiDegreeMark(ItemKeyDto itemKeyDto){
        if (ItemDto.TypeAlipay.equals(itemKeyDto.getItemDtoType())
                || ItemDto.TypePhonebill.equals(itemKeyDto.getItemDtoType())
                || ItemDto.TypeQB.equals(itemKeyDto.getItemDtoType())
                || ItemDto.TypeVirtual.equals(itemKeyDto.getItemDtoType())) {
            PriceDegreeDto pd = new PriceDegreeDto(itemKeyDto.getAppItem().getCustomPrice());
            return !pd.isSingleDegree();
        }else if(ItemDto.TypePhoneflow.equals(itemKeyDto.getItemDtoType())){//流量为动态获取档位，积分时多档位情况
            return true;
        }else{
            return false;
        }
    }

    public static boolean isOldData(ItemDto itemDto) {
        if(itemDto == null){
            return false;
        }
        if(itemDto.getVersion() == null || NumberUtils.compare(itemDto.getVersion(), CURRENT_ITEM_VERSION) < 0){
            return true;
        }
        return false;
    }
    public static boolean isNewData(Long version) {
        if(version == null){
            return false;
        }
        if(NumberUtils.compare(version, CURRENT_ITEM_VERSION) == 0){
            return true;
        }
        return false;
    }

    /**
     * 是否，充值类-微信立减金
     *
     * @param itemKey
     * @return
     */
    public static boolean isWxFavorCoupon(ItemKeyDto itemKey) {
        //目前微信立减金：兑吧虚拟商品、浦上渠道、商家编码18-开头。
        if (itemKey.getItem() == null) {
            return false;
        }
        return isWxFavorCoupon(itemKey.getItem());
    }

    public static boolean isWxFavorCoupon(ItemDto itemDto) {
        //目前微信立减金：兑吧充值商品、浦上渠道、商家编码18-开头,或者是 兑吧充值商品、福建兑吧微信立减金渠道
        if (!StringUtils.equals(ItemDto.TypeVirtual, itemDto.getType())) {
            return false;
        }
        boolean duibaVirtualFlag = itemDto.isOpTypeItem(ItemDto.OpTypeLimitVPro);
        if (!duibaVirtualFlag) {
            return false;
        }
        if (!StringUtils.equals(VisualItemChannelEnum.PU_SHANG.getCode(), itemDto.getMerchantCoding()) && !StringUtils.equals(VisualItemChannelEnum.FJ_DB_WXLJJ.getCode(), itemDto.getMerchantCoding())) {
            return false;
        }
        if (CollectionUtils.isEmpty(itemDto.getItemSkuDtoList())) {
            return false;
        }
        ItemSkuDto itemSkuDto = itemDto.getItemSkuDtoList().get(0);
        String merchantCoding = itemSkuDto.getMerchantCoding();
        if (StringUtils.isBlank(merchantCoding)) {
            return false;
        }
        if (StringUtils.equals(VisualItemChannelEnum.PU_SHANG.getCode(), itemDto.getMerchantCoding()) && !merchantCoding.startsWith("18-")) {
            return false;
        }
        return true;
    }

    /**
     * 是否需要填写账号
     * @param itemKey
     * @return boolean
     */
    public static Boolean isNeedUserAccount(ItemKeyDto itemKey) {
        if (itemKey.getItem() != null) {
            return itemKey.getItem().isOpTypeItem(ItemDto.OpTypeNeedUserName);
        } else if (itemKey.getAppItem() != null) {
            return itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeNeedUserName);
        } else {
            return false;
        }
    }
}
