package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.CreditsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.PreStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.PreStockPointDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by liuyao on 2017/1/11.
 * 预分配库存服务
 * 原有的 remotePreStockPointService 和 remotePreStockService 提供的查询业务性太弱 会导致dubbo多次调用
 * 这里将PreStockDO中的stock统一整合到PreStockPoint中, 同时变更为 PreStockDto
 */
public interface RemotePreStockService {

    /**
     * 获取兑吧商品对App的定向库存
     * 如果兑吧商品没有对该应用设置私有库存,则返回共享库
     * 如果兑吧商品没有设置库存预分配,则忽略itemId
     * @param itemIds
     * @param appId
     * @return
     */
    DubboResult<List<PreStockDto>> findAllPreStock(List<Long> itemIds,Long appId);
    
    /**
     * 查询预分配每日限量库存
     * @param itemId
     * @return 
     */
    DubboResult<Integer> findPreEeverdayStock(ItemDto item, Long appId);
    
	/**
	 * 计算消耗积分数 如果是有档次的兑换商品，传入degree，如果没有传入degreee，返回最小档次的积分
	 *
	 * @param key 商品
	 * @param degree 档位
	 * @param appCreditsRate APP的汇率字段
	 * @return
	 */
    DubboResult<Long> calculateCreditsByItemKeyAndDegree(ItemKeyDto key,String degree, Long appCreditsRate);
    
	/**
	 * 批量计算消耗积分数 如果是有档次的兑换商品，传入degree，如果没有传入degreee，返回最小档次的积分
	 * 
	 * @param itemKeys
	 * @return
	 */
    DubboResult<List<CreditsDto>> calculateCreditsByItemKeyAndDegree(List<CreditsDto> itemKeys);
    
    /**
     * 获取预分配的兑换价格
     * @param item
     * @param appCreditsRate
     * @return
     */
    DubboResult<Integer> getMinExchangePrice(ItemDto item, Long appId);

	DubboResult<Void> submitPreStock(List<PreStockPointDto> insertPointList, List<PreStockPointDto> updatePointList);

	DubboResult<PreStockDto> findByPointId(Long pointId);

	/**
	 * 计算消耗积分数 如果是有档次的兑换商品，传入degree，如果没有传入degreee，返回最小档次的积分
	 * @param key
	 * @param degree
	 * @param appRate
	 * @return
	 */
	DubboResult<Long> calculateCreditsByItemKeyAndDegree_manager(ItemKeyDto key, String degree, Long appRate);

	DubboResult<Integer> countSales(Long pointId);
}
