package cn.com.duiba.goods.center.api.remoteservice.dto;

import java.io.Serializable;

/**
 * 优惠券，被加入品牌或类别
 */
public class PCGCategorySellerGoodsDto extends BaseImgDto implements Comparable<PCGCategorySellerGoodsDto>,Serializable {
private static final long serialVersionUID = 1L;
    

    private Long pcgId;
    
    private String title;
    
    private String name;
    
    private String subtitle;
    
    private Integer minPrice;
    
    private Long switches;

    private String buttonText;
    
    private String interestPrice;
    
    private String interestDesc;
    
    private String backgroundColor;
    
    private String iconImage;
    
    private String detail;//描述详情信息
    
    private Integer limitPerConsumer;//用户限制次数
    
    private Long stock;//目前剩余库存
    
	private Integer payLoad;
	
	private Integer exchangeType;//1：已兑换，2：积分不足，3：已兑完，4：兑换
	private String startDate;
	private String endDate;
	private String unitName;
	private Long orderId;//订单id
	private GoodsDirectionalConfigDto goodsDirectionalConfigDto;

	public String getStartDate() {
		return startDate;
	}
	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}
	public String getEndDate() {
		return endDate;
	}
	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}
	public Integer getExchangeType() {
		return exchangeType;
	}
	public void setExchangeType(Integer exchangeType) {
		this.exchangeType = exchangeType;
	}
	public Long getPcgId() {
		return pcgId;
	}
	public void setPcgId(Long pcgId) {
		this.pcgId = pcgId;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getIconImage() {
		return iconImage;
	}
	public void setIconImage(String iconImage) {
		this.iconImage = iconImage;
	}
	public Integer getPayLoad() {
		return payLoad;
	}
	public void setPayLoad(Integer payLoad) {
		this.payLoad = payLoad;
	}
	
	
	public Long getSwitches() {
		return switches;
	}
	public void setSwitches(Long switches) {
		this.switches = switches;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getSubtitle() {
		return subtitle;
	}
	public void setSubtitle(String subtitle) {
		this.subtitle = subtitle;
	}
	public Integer getMinPrice() {
		return minPrice;
	}
	public void setMinPrice(Integer minPrice) {
		this.minPrice = minPrice;
	}
	
	public String getButtonText() {
		return buttonText;
	}
	public void setButtonText(String buttonText) {
		this.buttonText = buttonText;
	}
	
	public String getInterestPrice() {
		return interestPrice;
	}
	public void setInterestPrice(String interestPrice) {
		this.interestPrice = interestPrice;
	}
	public String getInterestDesc() {
		return interestDesc;
	}
	public void setInterestDesc(String interestDesc) {
		this.interestDesc = interestDesc;
	}
	public String getBackgroundColor() {
		return backgroundColor;
	}
	public void setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
	}
	public String getDetail() {
		return detail;
	}
	public void setDetail(String detail) {
		this.detail = detail;
	}
	public Integer getLimitPerConsumer() {
		return limitPerConsumer;
	}
	public void setLimitPerConsumer(Integer limitPerConsumer) {
		this.limitPerConsumer = limitPerConsumer;
	}
	public Long getStock() {
		return stock;
	}
	public void setStock(Long stock) {
		this.stock = stock;
	}
	
    public String getUnitName() {
		return unitName;
	}
	public void setUnitName(String unitName) {
		this.unitName = unitName;
	}

	@Override
	public boolean equals(Object o) {
		if (o == null)
			return false;
		if (this.getClass() != o.getClass())
			return false;
    	PCGCategorySellerGoodsDto m = (PCGCategorySellerGoodsDto)o;
		return this.pcgId.equals(m.getPcgId());
    }

	@Override
	public int hashCode() {
		return super.hashCode();
	}

    @Override
	public int compareTo(PCGCategorySellerGoodsDto o) {
		return this.getPayLoad().compareTo(o.getPayLoad());
	}
	public Long getOrderId() {
		return orderId;
	}
	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}
	public GoodsDirectionalConfigDto getGoodsDirectionalConfigDto() {
		return goodsDirectionalConfigDto;
	}
	public void setGoodsDirectionalConfigDto(
			GoodsDirectionalConfigDto goodsDirectionalConfigDto) {
		this.goodsDirectionalConfigDto = goodsDirectionalConfigDto;
	}
    
}
