package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemTagsDto;

import java.util.List;

/**
 * Created by wenqi.huang on 16/5/11.
 */
public interface RemoteItemTagsService {
    /**
     * 根据itemId和tagsId查询ItemTags
     *
     */
    public ItemTagsDto findByItemAndTags(Long itemId, Long tagsId);

    /**
     * 根据tagsId查询ItemTags
     *
     * @param tagsId
     * @return
     */
    public List<ItemTagsDto> findByTags(Long tagsId);

    /**
     * 删除ItemTags记录
     *
     * @param id
     */
    public void delete(Long id);

    /**
     * 删除ItemTags记录
     */
    public void deleteByItemId(Long itemId);

    /**
     * 包含该标签的兑换项数
     */
    public Integer countByTagsId(Long tagsId);

    /**
     * 根据itemId获取list
     */
    public List<ItemTagsDto> findAllByItemId(Long itemId);

    /**
     * 根据tagsId删除
     */
    public void deleteByTagsId(Long tagsId);

    /**
     * insert
     * @param itemTagsDO
     */
    public void insert(ItemTagsDto itemTagsDO);
}
