package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ExchangeStockWarnDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.StockWarnEmailDto;
import cn.com.duiba.goods.center.api.remoteservice.page.Pagination;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 兑吧商品后台接口
 */
public interface RemoteDuibaItemGoodsBackendService {

	/**
	 * 根据type查询（仅限于自冲类）
	 */
	public DubboResult<List<ItemDto>> findByInTypes(List<String> types);

	/**
	 * 根据名称搜索
	 * 
	 * @param name
	 * @return
	 */
	public DubboResult<List<ItemDto>> findAllByName(String name);

	/**
	 * 根据模版ID查询引用的商品
	 * 
	 * @param expressTemplateId
	 * @return
	 */
	public DubboResult<List<ItemDto>> findAllByExpressTemplateId(Long expressTemplateId);

	/**
	 * 自动关闭时间置为null
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<Integer> updateAutoOffDateNull(Long id);

	/**
	 * 把限制次数置为空
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<Integer> updateLimitCountNull(Long id);

	/**
	 * 根据ID
	 * 
	 * @param id
	 * @param validEndDate
	 * @return
	 */
	public DubboResult<Integer> updateValidEndDateById(Long id, Date validEndDate);

	/**
	 * 修改位运算
	 * 
	 * @param id
	 * @param operationsType
	 */
	public DubboResult<Integer> updateOperationsTypeById(Long id, Integer operationsType);

	/**
	 * 根据sourceRelation和sourceType进行查询
	 * 
	 * @param sourceRelationId
	 * @param sourceType
	 * @return
	 */
	public DubboResult<ItemDto> findBySourceRelationIdAndSourceType(Long sourceRelationId, Integer sourceType);

	/**
	 * 获取所有能添加到专题活动中的兑吧兑换项
	 * 
	 * @param enable
	 * @return
	 */
	public DubboResult<List<ItemDto>> findAllActivityItemAndEnable(Boolean enable);

	/**
	 * 获取可以展示在秒杀专题中的兑换项
	 */
	public DubboResult<List<ItemDto>> findAllForDuibaSecondsKill();

	/**
	 * 获取库存迁移目标Item列表
	 * 
	 * @param type
	 * @param deleted
	 * @param subType
	 * @return
	 */
	public DubboResult<List<ItemDto>> findAllTargetItemList(String type, Boolean deleted, Integer subType);

	/**
	 * 管理员后台分页查询item列表
	 * 
	 * @param query
	 * @return
	 */
	public DubboResult<Page<ItemDto>> findAdminItemPage(Map<String, Object> query);

	/**
	 * 查询推荐中的兑换项，管理员后台使用
	 * 
	 * @param itemName
	 * @return
	 */
	public DubboResult<Page<ItemDto>> findRecommandItems(String itemName);

	/**
	 * 修改是否自动推荐
	 * 
	 * @param id
	 * @param autoRecommend
	 * @return
	 */
	public DubboResult<Integer> updateAutoRecommendById(Long id, Boolean autoRecommend);

	/**
	 * 更新payload
	 * 
	 * @param id
	 * @param payload
	 * @return
	 */
	public DubboResult<Integer> updatePayloadById(Long id, Integer payload);

	/**
	 * 系统推荐的兑换项 + 关联的兑换项（可能包含不是自动推荐的兑换项） 二者互斥关系
	 * 
	 * @param tagsId
	 * @return
	 */
	public DubboResult<List<Long>> findAutoRecommendAndTagsItems(Long tagsId);

	/**
	 * 获取给活动用的items
	 * 
	 * @param name
	 * @param type
	 * @return
	 */
	public DubboResult<List<ItemDto>> findAllByNameAndType4Lottery(String name, String type);

	/**
	 * 查询所有启用状态的兑换项的id
	 * 
	 * @param enable
	 * @return
	 */
	public DubboResult<List<Long>> findIdAllByEnable(Boolean enable);

	/**
	 * 把分类ID置为空
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<Integer> updateItemClassifyIdNullById(Long id);

	/**
	 * 根据分类ids进行in查询
	 * 
	 * @param classifyIds
	 * @return
	 */
	public DubboResult<List<ItemDto>> findAllByClassify(List<Long> classifyIds);

	/**
	 * 查询所有管理员后台所有启用状态的优惠券，按id倒序
	 */
	public DubboResult<List<ItemDto>> findAllEnableCoupon();

	/**
	 * 兑换项库存列表查询
	 * 
	 * @param queryMap
	 * @return
	 */
	public DubboResult<Page<ExchangeStockWarnDto>> findExchangeStockWarnList(Map<String, Object> queryMap);

	/**
	 * 查询兑换项库存预警列表
	 * 
	 * @param queryMap
	 * @return
	 */
	public DubboResult<List<ExchangeStockWarnDto>> findItemStockWarns(Map<String, Object> queryMap);

	/**
	 * 清空兑换项库存表
	 */
	public DubboResult<Void> emptyExchangeStockWarn();

	/**
	 * 插入兑换项库存表
	 * 
	 * @param exchangeStockWarn
	 */
	public DubboResult<Void> saveExchangeStockWarn(ExchangeStockWarnDto exchangeStockWarn);

	/**
	 * 库存邮箱预警列表
	 * @param queryMap
	 * @return
	 */
	public DubboResult<List<StockWarnEmailDto>> findEmailStockList(Map<String, Object> queryMap);

	/**
	 * 库存邮箱预警保存
	 * @param emailStr
	 */
	public DubboResult<Void> saveEmailStockWarn(String emailStr);
	
    /**
     * 库存邮箱预警清空
     */
    public DubboResult<Void> emptyEmailStockWarn();

	/**
	 * 开发者后台兑吧待选库的查询分页
	 */
	public DubboResult<List<ItemDto>> findDuibaItemChoose(Map<String, Object> paramMap);

    /**
     * findDuibaItemChooseCount
     * @param paramMap
     * @return
     */
    public DubboResult<Long> findDuibaItemChooseCount(Map<String, Object> paramMap);
    
    /**
     * findAllBlacklistItem
     * @return
     */
    public DubboResult<List<ItemDto>> findAllBlacklistItem();
    
    /**
     * 查询一天内定时下架的兑换项（优惠券，实物）
     */
    public DubboResult<List<ItemDto>> findAutoOffItem();
    
    /**
     * 状态变更
     * enable: 为true时需要调用DuibaEventsDispatcher.get().dispatchEvent(new DuibaItemEvent(item, DuibaItemEvent.DuibaItemEventType.OnItemDisable));
     * @param itemId
     * @param enable
     * @return
     */
    public DubboResult<Boolean> changeStatus(Long itemId, Boolean enable);
    
    /**
     * findAllPreStockItems
     * @param opType
     * @return
     */
    public DubboResult<List<Long>> findAllPreStockItems(Long appId, int opType);
    
    /**
     * findAllByIdsOrderByIdStr
     * @param ids
     * @param idsStr
     * @return
     */
    public DubboResult<List<ItemDto>> findAllByIdsOrderByIdStr(List<Long> ids, String idsStr);

	DubboResult<Pagination<ItemDto>> findItemPageById(Map<String, Object> query);

	DubboResult<Map<Long, List<Long>>> findAppIdByItemIdMasking(List<Long> itemId);

	DubboResult<Integer> updateRemaingById(Long id, Integer remaining);

	DubboResult<Integer> updateSubTypeById(Long id, Integer subType);
}
