package cn.com.duiba.goods.center.api.remoteservice.item;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponQueryParamDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.CouponBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.CouponCountDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.CouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 兑换项优惠券商品后台接口
 */
public interface RemoteItemCouponGoodsBackendService {

    /**
     * 删除券码
     * @param itemKeyDto
     * @param couponId
     */
    public void deleteCouponCode(ItemKeyDto itemKeyDto, Long couponId);

    /**
     * 只检索了id,开始时间和结束时间
     */
    public List<GoodsBatchDto> findAllBatchSimple(ItemKeyDto itemKeyDto, Long gid);


    /**
     * 查询兑换项-优惠券的所有批次
     *
     * @param itemKeyDto
     * @param valid
     *            NULL-所有批次 不包含删除的批次 "valid"--正在使用和新建的批次
     * @return
     */
    public List<GoodsBatchDto> findAllBatch(ItemKeyDto itemKeyDto, String valid);

    /**
     * 查询商品批次个数
     * @param itemKeyDto
     * @return
     */
    public Long findBatchNum(ItemKeyDto itemKeyDto);

    /**
     * 查询商品批次
     * @param itemKeyDto
     * @param batchId
     * @return
     */
    public GoodsBatchDto findBatch(ItemKeyDto itemKeyDto, Long batchId);

    /**
     * 查询批次下的一个券码
     * @param itemKeyDto
     * @param batchId
     * @return
     */
    public GoodsCouponDto findOneByBatch(ItemKeyDto itemKeyDto, Long batchId);

    /**
     * 优惠券搜索
     * @param code
     * @param batchId
     * @param start
     * @param pageSize
     * @return
     */
    public List<GoodsCouponDto> searchCoupon(Long appItemId, Long itemId, String code, Long batchId, String used, Integer start, Integer pageSize);

    public Integer countCoupon(Long appItemId, Long itemId, Long batchId);

    public Integer countUsedCoupon(Long appItemId, Long itemId, Long batchId);
	
	/**
	 * 批量优惠券码分页
	 * @param param
	 * @return
	 */
	DubboResult<List<GoodsCouponDto>> findPageByBatchIdAndStatus(GoodsCouponQueryParamDto param);
	
	/**
	 * 导入普通券码
	 * @param itemKeyDto
	 * @param batchId
	 * @param startDay
	 * @param endDay
	 * @param fileUrl
	 * @return
	 */
	public DubboResult<Long> importCouponNormal(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String fileUrl);
	
	/**
	 * 导入链接券码
	 * @param itemKeyDto
	 * @param batchId
	 * @param startDay
	 * @param endDay
	 * @param link
	 * @param stock
	 * @return
	 */
	public DubboResult<Boolean> importCouponLink(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String link, Long stock);
	
	/**
	 * 导入重复券码
	 * @param itemKeyDto
	 * @param batchId
	 * @param startDay
	 * @param endDay
	 * @param code
	 * @param password
	 * @param stock
	 * @return
	 */
	public DubboResult<Boolean> importCouponRepeat(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String code, String password, Long stock);

    /**
     * findCouponByLimit
     * 优惠券翻页
     */
    public List<CouponDto> findCouponByLimit(Map<String, Object> params);

    /**
     * findCouponByCount
     * @param params
     * @return
     */
    public Long findCouponByCount(Map<String, Object> params);

    /**
     * 根据itemId获取最后一个批次
     */
    public CouponBatchDto findLastBatchByItemId(Long itemId);

    /**
     * countByItemId
     * @param itemId
     * @return
     */
    public Integer countByItemId(Long itemId);

    /**
     * countByItemIds
     * @param itemIds
     * @return
     */
    public List<CouponCountDto> countByItemIds(List<Long> itemIds);

    /**
     * findBatchInIds
     * @param ids
     * @return
     */
    public List<CouponBatchDto> findBatchInIds(List<Long> ids);


}
