package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.AppItemClassifyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * Created by xiaoxuda on 2016/11/17.
 */
@AdvancedFeignClient
public interface RemoteAppItemClassifyService {
    /**
     * 根据id查询商品分类信息
     * @param id
     * @return
     */
    public DubboResult<AppItemClassifyDto> find(Long id);

    /**
     * 删除relation
     * @param appItemId
     * @return
     */
    public DubboResult<Integer> deleteRelationAppItem(Long appItemId);

    /**
     * findByIds
     * @param ids
     * @return
     */
    List<AppItemClassifyDto> findByIds(List<Long> ids);

    /**
     * findAllByAppId
     * @param appId
     * @return
     */
    List<AppItemClassifyDto> findAllByAppId(Long appId);

    /**
     * update
     * @param appItemClassifyDto
     */
    public void update(AppItemClassifyDto appItemClassifyDto);


    /**
     * 自定义分类商品排序
     */
    public void sortByClassifyPayload(Long classifyId, Long appItemId, Integer startPayload, Integer endPayload);

    /**
     * 自定义分类商品置顶
     */
    public void setTop(Long classifyId, Long appItemId);

    /**
     * 自定义分类商品取消置顶
     */
    public void cancleTop(Long classifyId, Long appItemId);

    public Long findByCount(Map<String, Object> params);

    public List<AppItemClassifyDto> findByLimit(Map<String, Object> params);

    public Integer deleteClassifyAllAppItem(Long classifyId);

    public int deleteClassifyAppItem(Long classifyId, Long appItemId);

    public int batchInsert(List<Map<String, Object>> classifyRelation);

    public List<Long> findAllAppItemById(Long classifyId);

    public int deleteAppItemRelation(List<Long> ids, Long appId);

    public void insert(AppItemClassifyDto appItemClassifyDO);

    public Integer findMaxPayload(Long classifyId);

    public Integer updatePayload(Long appItemId, Long classifyId, Integer payload);

}
