package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 开发者定制服务，主要用于开发者后台
 * Created by xiaoxuda on 2017/03/27.
 */
@AdvancedFeignClient
public interface RemoteDevCustomizedBackendService {

    /**
     * 对传入的appItem序列进行权重倒序排序，
     *
     * @param appId
     * @param sortAppItemIds 需要排序的AppItemId列表
     */
    DubboResult<Boolean> indexItemSort(Long appId, List<Long> sortAppItemIds);

    /**
     * appItem序列置顶
     *
     * @param appId
     * @param appItemId   需要置顶的AppItemId
     */
    DubboResult<Boolean> setTop4IndexItem(Long appId, Long appItemId);

    /**
     * appItem取消置顶
     *
     * @param appId
     * @param appItemId   需要取消置顶的AppItemId
     */
    DubboResult<Boolean> cancelTop4IndexItem(Long appId, Long appItemId);
}
