package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;
import java.util.Date;

/**
 * 兑吧商品DTO
 */
public class ItemDto implements Serializable {

    private static final long serialVersionUID = -2680175256212159924L;

    public static final String Key_Ganji = "ganji";//控制是否显示马上使用按钮的开关，原来就赶集一个应用定制了这个功能，所以命名有些那个。。
    public static final String LuckyBag = "lucky"; // 福袋
    public static final String LuckyBagTxt = "福袋"; // 福袋
    /**话费*/
    public static final String TypePhonebill = "phonebill";
    /**QB*/
    public static final String TypeQB = "qb";
    /**优惠券 */
    public static final String TypeCoupon = "coupon";
    /**支付宝码 */
    public static final String TypeAlipayCode = "alipaycode";
    /**支付宝fast */
    public static final String TypeAlipayFast = "alipayfast";
    /**支付宝 */
    public static final String TypeAlipay = "alipay";
    /**实物 */
    public static final String TypeObject = "object";
    /**游戏充值卡 */
    public static final String TypeGameCard = "gamecard";
    /**流量 */
    public static final String TypePhoneflow = "phoneflow";
    /**大转盘 */
    public static final String TypeTurntable = "turntable";
    /**单品抽奖 */
    public static final String TypeSingleLottery = "singleLottery";
    /**手动开奖 */
    public static final String TypeManualLottery = "manualLottery"; 
    /**活动工具 */
    public static final String TypeHdtollLottery = "hdtoolLottery";
    /**游戏 */
    public static final String TypeGameLottery = "gameLottery";
    /**答题 */
    public static final String TypeQuestionLottery = "questionLottery";
    /**测试题 */
    public static final String TypeQuizzLottery = "quizzLottery";
    /**新游戏 */
    public static final String TypeNgameLottery = "ngameLottery";
    /**竞猜 */
    public static final String TypeGuessLottery = "guessLottery";
    /**伪造类型 兑换项(一般当作入口) */
    public static final String TypeFake = "fake";
    /**虚拟商品 */
    public static final String TypeVirtual = "virtual";
    /**定制的单档位话费类型 */
    public static final String TypePhonebillDingzhi = "phonebillDingzhi";
    /**免费类（实物和优惠券） */
    public static final String TypeListFree = "free";
    /**收费类（实物和优惠券） */
    public static final String TypeListCharge = "charge";
    /**集卡商品 */
    public static final String TypeCollectGoods = "collectGoods";
    /** 开心码商品 */
    public static final String TYPE_HAPPY_CODE = "happyCode";
    
    /**优惠券子类型（普通优惠券）*/
    public static final int SubTypeCommon = 0;
    /**优惠券子类型（链接类型优惠券）*/
    public static final int SubTypeLink = 1;
    /**优惠券子类型（可重复优惠券）*/
    public static final int SubTypeRepeat = 2;

	public static final int TypeIntPhonebill = 1;
	public static final int TypeIntQB = 2;
	public static final int TypeIntPhoneflow = 3;
	public static final int TypeIntCoupon = 4;
	public static final int TypeIntAlipayCode = 5;
	public static final int TypeIntAlipayFast = 6;
	public static final int TypeIntAlipay = 7;
	public static final int TypeIntObject = 8;
	public static final int TypeIntGameCard = 9;
	public static final int TypeIntTurntable = 10;

	/**永久限制*/
    public static final String LimitTypeForever = "forever";
    /**每日限制*/
    public static final String LimitTypeEveryday = "everyday";
    /**
     * 周期限制,前缀
     */
    public static final String LimitTypePeriod ="DAY_";
    /**批次限制*/
    public static final String LimitTypeBatch = "batch";
    /**每月限制*/
    public static final String LimitTypeMonth = "month";


    /**限时商品 */
    public static final int OpTypeTimeLimit=0;
    /**限量商品 */
    public static final int OpTypeQuantityLimit=1;	
    /**活动专用商品 */
    public static final int OpTypeActivity=2;
    /**定向商品 */
    public static final int OpTypeSpecify=3;
    /**待审核 */
    public static final int OpTypeDevAudit=4;
    /**黑名单商品 */
    public static final int OpTypeDevBlacklist=5;
    /**涉及商品在已添加到图标或Banner图区后，是否需要在首页兑换区隐藏 */
    public static final int OpTypeIndexHidden=6;
    /**兑吧优惠券是否在安卓环境下，点立即领取时，开启出现弹窗提示 */
    public static final int OpTypeAndriodAlert=7;
    /**已抢光 */
    public static final int OpTypeTimeLimitSwitch=8;
    /**判断是否开启了地域限制 */
    public static final int OpTypeAddrLimit = 9;
    /**判断兑吧商品是否开启库存预分配功能 */
    public static final int OpTypePreStockSwith = 10;
    /**判断商品是否是加钱购商品 */
    public static final int OpTypeIsAmb = 11;
    /**开发者端市场价值，是否是积分，默认是积分 */
    public static final int OpTypeCredits = 12;
    /**虚拟商品在兑换时是否需要输入账号 */
    public static final int OpTypeNeedUserName = 13;
    /**判断是否是商品中心优惠券 */
    public static final int OpTypeGoodsCoupon = 16;
    /**判断是否推啊广告类型 兑换项 */
	public static final int OpTypeTuiaItem = 17;
	 /**判断是否推啊微信券 兑换项 */
	public static final int OpTypeWeixinItem = 18;
	 /**判断是否推啊大平台免费券 兑换项 */
	public static final int OpTypePlatformItem = 19;
    /**判断是否需要每次开启校验码校验 */
    public static final int OpTypeCaptchaCheck = 20;

	/** 普通兑换*/
    public static final int SourceTypeNormal = 0;
    /** 单品抽奖*/
    public static final int SourceTypeSingleLottery = 1;
    /** 秒杀活动*/
    public static final int SourceTypeKillActivity = 2;

    //链接类型优惠券 按钮往哪跳
    /** 商家落地页*/
    public static final int LinkToBussiness = 0;
    /** 兑换详情页*/
    public static final int LinkToDetail = 1;

    public static final String ExpressTypeFree="free";
    public static final String ExpressTypeUnity="unity";
    public static final String ExpressTypeTemplate="template";

    /** 秒杀系统实物直充类标签 */
    public static final int ObjectTypeNormal = 0;
    public static final int ObjectTypePhone = 1;
    public static final int ObjectTypeQB = 2;
    public static final int ObjectTypeAlipay = 3;

    public ItemDto() {
    }

    public ItemDto(boolean init4insert) {
        if (init4insert) {
            facePrice = 0;
            marketPrice = 0;
            actualPrice = 0;
            minCredits = 0L;
            minFacePrice = 0;
            enable = false;
            remaining = 0;
            sales = 0;
            payload = 0;
            duibaType = 0;
            autoRecommend = false;
            deleted = false;
            sourceType = SourceTypeNormal;
            shutDown = false;
            operationsType = 0;
            limitScope = ItemDto.LimitTypeForever;
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    private Long    id;
    private String  tag;
    private String  name;
    private String  subtitle;
    private String  logo;
    private String  image;
    private String  multiImage;
    private Integer facePrice;
    private Integer marketPrice;
    private Integer actualPrice;
    private Long    minCredits;
    private Integer minFacePrice;
    private String  description;
    private Boolean suggestDownload;
    private String  iosOpen;
    private String  iosDownload;
    private String  androidDownload;
    private Boolean enable;
    private Integer remaining;
    private Integer sales;
    private Integer payload;
    private String  customPrice;
    private String  smallImage;
    private String  whiteImage;
    private Integer limitCount;
    private String  limitScope;
    private String  type;
    private Integer typeInt;
    private String  exchangeTipTemplate;
    private Long    ownerAppId;
    private Long    batchId;
    private Long    itemClassifyId;
    private Date    validStartDate;
    private Date    validEndDate;
    private Date    publishTime;
    private Boolean deleted;
    private String  productPrice;
    private Boolean shutDown;
    private Boolean showAlert;
    private String  alertMessage;
    private Integer duibaType;
    private Boolean autoRecommend;
    private Integer subType;
    private String  bannerImage;
    private Date    gmtCreate;
    private Date    gmtModified;
    private Integer operationsType;
    private String  limitTimeBetween;
    private Integer limitEverydayQuantity;
    private String  limitDate;
    private Integer sourceType;
    private Long    sourceRelationId;
    private Date    autoOffDate;
    private String  name4Admin;
    private String  usePrompt;
    private String  btnText;
    private Long    salePrice;
    private String  expressType;
    private Long    expressPrice;
    private Long    expressTemplateId;
    private Integer stockWarnValue;
    private Long    sellerId;
    private String  sellerName;
    private Long    adminId;
    private Integer immediatelyButton;

    //extra dto
    private ItemExtraDto itemExtraDto;

    private Long stockId;//关联库存中心的stockId

	/**
	 *  直接在DTO中进行开关的切换比较危险,请直接使用SwitchUtils
	 *
	 * @param opType
	 */
	@Deprecated
    public void grantOpTypeItem(int opType) {
        int v = 1 << opType;
        this.operationsType = this.operationsType | v;
    }
    
    /**
     * ungrantOpTypeItem
     * @param opType
     */
    public void ungrantOpTypeItem(int opType) {
        int v = 1 << opType;
        v = ~v;
        this.operationsType = this.operationsType & v;
    }

    /**
     * ungrantOpTypeItem
     * @param opType
     * @return
     */
    public boolean isOpTypeItem(int opType) {
        int v = 1 << opType;
        int ret = this.operationsType & v;
        return ret != 0;
    }

    /**
     * 判断Item是否是档位类型
     * @return
     */
    public boolean isDegree(){
        if(TypePhonebill.equals(type)){
            return true;
        }
        if(TypeQB.equals(type)){
            return true;
        }
        if(TypeAlipay.equals(type)){
            return true;
        }
        if(TypeAlipayFast.equals(type)){
            return true;
        }
        if(TypeAlipayCode.equals(type)){
            return true;
        }
        return false;
    }

	/**
	 * 判断是否不需要库存
	 * @return
     */
	public boolean isNoStock() {
		if(TypePhonebill.equals(type)){
			return true;
		}
		if(TypePhoneflow.equals(type)){
			return true;
		}
		if(TypeQB.equals(type)){
			return true;
		}
		if(TypeAlipay.equals(type)){
			return true;
		}
		if(TypeAlipayFast.equals(type)){
			return true;
		}
		if(TypeAlipayCode.equals(type)){
			return true;
		}
		if(TypePhonebillDingzhi.equals(type)){
			return true;
		}
		return false;
	}

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getMultiImage() {
        return multiImage;
    }

    public void setMultiImage(String multiImage) {
        this.multiImage = multiImage;
    }

    public Integer getFacePrice() {
        return facePrice;
    }

    public void setFacePrice(Integer facePrice) {
        this.facePrice = facePrice;
    }

    public Integer getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(Integer marketPrice) {
        this.marketPrice = marketPrice;
    }

    public Integer getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Integer actualPrice) {
        this.actualPrice = actualPrice;
    }

	public Long getMinCredits() {
		return minCredits;
	}

	public void setMinCredits(Long minCredits) {
		this.minCredits = minCredits;
	}

	public Integer getMinFacePrice() {
		return minFacePrice;
	}

	public void setMinFacePrice(Integer minFacePrice) {
		this.minFacePrice = minFacePrice;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Boolean getSuggestDownload() {
		return suggestDownload;
	}

	public void setSuggestDownload(Boolean suggestDownload) {
		this.suggestDownload = suggestDownload;
	}

	public String getIosOpen() {
		return iosOpen;
	}

	public void setIosOpen(String iosOpen) {
		this.iosOpen = iosOpen;
	}

	public String getIosDownload() {
		return iosDownload;
	}

	public void setIosDownload(String iosDownload) {
		this.iosDownload = iosDownload;
	}

	public String getAndroidDownload() {
		return androidDownload;
	}

	public void setAndroidDownload(String androidDownload) {
		this.androidDownload = androidDownload;
	}

	public Boolean getEnable() {
		return enable;
	}

	public void setEnable(Boolean enable) {
		this.enable = enable;
	}

	public Integer getRemaining() {
		return remaining;
	}

	public void setRemaining(Integer remaining) {
		this.remaining = remaining;
	}

	public Integer getSales() {
		return sales;
	}

	public void setSales(Integer sales) {
		this.sales = sales;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public String getCustomPrice() {
		return customPrice;
	}

	public void setCustomPrice(String customPrice) {
		this.customPrice = customPrice;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public String getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(String limitScope) {
		this.limitScope = limitScope;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getTypeInt() {
		return typeInt;
	}

	public void setTypeInt(Integer typeInt) {
		this.typeInt = typeInt;
	}

	public Long getOwnerAppId() {
		return ownerAppId;
	}

	public void setOwnerAppId(Long ownerAppId) {
		this.ownerAppId = ownerAppId;
	}

	public Long getBatchId() {
		return batchId;
	}

	public void setBatchId(Long batchId) {
		this.batchId = batchId;
	}

	public Long getItemClassifyId() {
		return itemClassifyId;
	}

	public void setItemClassifyId(Long itemClassifyId) {
		this.itemClassifyId = itemClassifyId;
	}

	public Date getValidStartDate() {
		return validStartDate;
	}

	public void setValidStartDate(Date validStartDate) {
		this.validStartDate = validStartDate;
	}

	public Date getValidEndDate() {
		return validEndDate;
	}

	public void setValidEndDate(Date validEndDate) {
		this.validEndDate = validEndDate;
	}

	public Date getPublishTime() {
		return publishTime;
	}

	public void setPublishTime(Date publishTime) {
		this.publishTime = publishTime;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public String getProductPrice() {
		return productPrice;
	}

	public void setProductPrice(String productPrice) {
		this.productPrice = productPrice;
	}

	public Boolean getShutDown() {
		return shutDown;
	}

	public void setShutDown(Boolean shutDown) {
		this.shutDown = shutDown;
	}

	public Boolean getShowAlert() {
		return showAlert;
	}

	public void setShowAlert(Boolean showAlert) {
		this.showAlert = showAlert;
	}

	public String getAlertMessage() {
		return alertMessage;
	}

	public void setAlertMessage(String alertMessage) {
		this.alertMessage = alertMessage;
	}

	public Integer getDuibaType() {
		return duibaType;
	}

	public void setDuibaType(Integer duibaType) {
		this.duibaType = duibaType;
	}

	public Boolean getAutoRecommend() {
		return autoRecommend;
	}

	public void setAutoRecommend(Boolean autoRecommend) {
		this.autoRecommend = autoRecommend;
	}

	public Integer getSubType() {
		return subType;
	}

	public void setSubType(Integer subType) {
		this.subType = subType;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Integer getOperationsType() {
		return operationsType;
	}

	public void setOperationsType(Integer operationsType) {
		this.operationsType = operationsType;
	}

	public String getLimitTimeBetween() {
		return limitTimeBetween;
	}

	public void setLimitTimeBetween(String limitTimeBetween) {
		this.limitTimeBetween = limitTimeBetween;
	}

	public Integer getLimitEverydayQuantity() {
		return limitEverydayQuantity;
	}

	public void setLimitEverydayQuantity(Integer limitEverydayQuantity) {
		this.limitEverydayQuantity = limitEverydayQuantity;
	}

	public String getLimitDate() {
		return limitDate;
	}

	public void setLimitDate(String limitDate) {
		this.limitDate = limitDate;
	}

	public Integer getSourceType() {
		return sourceType;
	}

	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	public Long getSourceRelationId() {
		return sourceRelationId;
	}

	public void setSourceRelationId(Long sourceRelationId) {
		this.sourceRelationId = sourceRelationId;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public String getName4Admin() {
		return name4Admin;
	}

	public void setName4Admin(String name4Admin) {
		this.name4Admin = name4Admin;
	}

	public String getUsePrompt() {
		return usePrompt;
	}

	public void setUsePrompt(String usePrompt) {
		this.usePrompt = usePrompt;
	}

	public String getBtnText() {
		return btnText;
	}

	public void setBtnText(String btnText) {
		this.btnText = btnText;
	}

	public Long getSalePrice() {
		return salePrice;
	}

	public void setSalePrice(Long salePrice) {
		this.salePrice = salePrice;
	}

	public String getExpressType() {
		return expressType;
	}

	public void setExpressType(String expressType) {
		this.expressType = expressType;
	}

	public Long getExpressPrice() {
		return expressPrice;
	}

	public void setExpressPrice(Long expressPrice) {
		this.expressPrice = expressPrice;
	}

	public Long getExpressTemplateId() {
		return expressTemplateId;
	}

	public void setExpressTemplateId(Long expressTemplateId) {
		this.expressTemplateId = expressTemplateId;
	}

	public Integer getStockWarnValue() {
		return stockWarnValue;
	}

	public void setStockWarnValue(Integer stockWarnValue) {
		this.stockWarnValue = stockWarnValue;
	}

	public Long getSellerId() {
		return sellerId;
	}

	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public String getSellerName() {
		return sellerName;
	}

	public void setSellerName(String sellerName) {
		this.sellerName = sellerName;
	}

	public Long getAdminId() {
		return adminId;
	}

	public void setAdminId(Long adminId) {
		this.adminId = adminId;
	}

	public Integer getImmediatelyButton() {
		return immediatelyButton;
	}

	public void setImmediatelyButton(Integer immediatelyButton) {
		this.immediatelyButton = immediatelyButton;
	}

	public String getExchangeTipTemplate() {
		return exchangeTipTemplate;
	}

	public void setExchangeTipTemplate(String exchangeTipTemplate) {
		this.exchangeTipTemplate = exchangeTipTemplate;
	}

    public ItemExtraDto getItemExtraDto() {
        return itemExtraDto;
    }

    public void setItemExtraDto(ItemExtraDto itemExtraDto) {
        this.itemExtraDto = itemExtraDto;
    }

    public Long getStockId() {
        return stockId;
    }

    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }
}
