package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 开发者商品后台接口
 */
@AdvancedFeignClient
public interface RemoteAppItemGoodsBackendService {

	/**
	 * 修改状态
	 * 
	 * @return
	 */
	public DubboResult<Integer> updateStatusByActivityId(String status, Boolean deleted, List<Long> relationIds);

	/**
	 * 根据兑吧商品ID查询开发者商品个数
	 * 
	 * @param itemId
	 * @return
	 */
	public DubboResult<Integer> findCountByItemId(Long itemId);

	/**
	 * 根据兑吧商品ID查询开发者上架和的商品
	 * 
	 * @param itemId
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findOnShelfByItemId(Long itemId);

	/**
	 * 上架或者下架
	 */
	public DubboResult<Integer> standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay);

	/**
	 * 更新活动工具兑换项入口
	 * @Deprecated, 推荐用：updateHdtoolAppItem(AppItemDto dto)
	 * @param id
	 * @param title
	 * @param smallImage
	 * @param whiteImage
	 * @param credits
	 * @param customPrice
	 * @param logo
	 * @param operationsType
	 * @return
	 */
	public DubboResult<Integer> updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo, Integer operationsType);


	/**
	 * 更新活动工具兑换项入口
	 * @param dto
	 * @return
	 */
	@RequestMapping("updateHdtoolAppItemByDto")
	DubboResult<Integer> updateHdtoolAppItem(AppItemDto dto);

	/**
	 * 更新专题活动主推兑换项属性
	 * 
	 * @param id
	 * @param title
	 * @param logo
	 * @param smallImage
	 * @param whiteImage
	 * @param bannerImage
	 * @param credits
	 * @param subtitle
	 * @return
	 */
	public DubboResult<Integer> updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle);


	/**
	 * 更新专题活动主推兑换项属性
	 * @Deprecated, 推荐用：updateMainPushAppItem(AppItemDto dto)
	 * @return
	 */
	@RequestMapping("updateMainPushAppItemByDto")
	public DubboResult<Integer> updateMainPushAppItem(AppItemDto dto);

	/**
	 * findAllBySourceTypeAndRelationIdAndDeleted
	 * 
	 * @param sourceType
	 * @param sourceRelationId
	 * @param deleted
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findAllBySourceTypeAndRelationIdAndDeleted(int sourceType, long sourceRelationId, Boolean deleted);

	/**
	 * publishItem分页查询
	 * 
	 * @param queryPublish
	 * @return
	 */
	public DubboResult<Page<AppItemDto>> findPublishItemLimit(Map<String, Object> queryPublish);

	/**
	 * 分页查询
	 * 
	 * @param params
	 * @return
	 */
	public DubboResult<Page<AppItemDto>> findByLimit(Map<String, Object> params);
	
	/**
	 * 根据类型批量查询
	 * @param appId
	 * @param type
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findAllByAppIdAndInType(Long appId, String[] type);
	
	/**
	 * 根据类型查询
	 * @param appId
	 * @param type
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findAllByAppIdAndType(Long appId, String type);
	
    /**
     * 获取上架中的兑换项数量，不包含活动兑换项入口
     */
    public DubboResult<Integer> findOnlineCount(Long appId);
    
    /**
     * 获取库存不足的兑换项的数量
     */
    public DubboResult<Integer> getRemaining0Count(Long appId);

    /**
     * 获取直冲类的ID,没有则添加
     */
    public DubboResult<Long> getOrAddAppItemId(String type, Long appId, Long appCreditsRate);
    
    /**
     * findAllUpVirtaulAppItems
     * @param appId
     * @return
     */
    public DubboResult<List<AppItemDto>> findAllUpVirtaulAppItems(Long appId);
    
    /**
     * doBatchDel
     * 删除完毕后需要调用 DuibaEventsDispatcher.get().dispatchEvent(new ItemEvent(ItemEvent.ItemEventType.onDeleted, key));
     * @param appId
     * @param developerId
     * @param appItemIds
     */
    public DubboResult<Boolean> doBatchDel(Long appId, Long developerId, List<Long> appItemIds);
    
    /**
     * 添加一次测试商品
     * @param appId
     */
    public DubboResult<Long> addTestAppItem(Long appId);
    
    /**
     * 批量上架
     * @param appId
     * @param appItemIds
     * @return
     */
    public DubboResult<Integer> bathcStandUp(Long appId, String virtualExchangeUrl, List<Long> appItemIds);
    
    /**
     * 上架或者下架
     */
    public DubboResult<Boolean> standUpOrDown(Long appId, Long appItemId, String status);
    
    /**
     * 排序自定义分类
     * @param classifyId
     * @param appItemIds
     * @return
     */
    public DubboResult<Integer> sortClassifyAppItem(Long classifyId, List<Long> appItemIds);
    
    /**
     * 修改实物商品
     * @param appItem
     * @param preRemaining
     * @param remaining
     * @param exchangeLimit
     * @param arealimitSwitch
     * @param arealimitType
     * @param arealimitAreas
     * @return
     */
    public DubboResult<Long> doUpdateOwnerObject(AppItemDto appItem, Integer preRemaining, Integer remaining, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas);
     
    /**
     * 获取app下所有上架的可用的自有商品
     * 
     * @param appId
     * @param types 类型
     * @param warnLine 库存预警线(实物,虚拟商品)
     * @return
     */
    public DubboResult<List<Long>> findSelfAppItemIdsByAppId(Long appId,List<String> types,Integer warnLine);
    
    /**
     * selectItemStore
     * @param appId
     * @param itemId
     * @return
     */
    public DubboResult<AppItemDto> selectItemStore(Long appId, Long itemId);
    
    /**
     * addItem2Myrepo
     * @param appId
     * @param itemId
     * @return
     */
    public DubboResult<AppItemDto> addItem2Myrepo(Long appId, Long itemId, Long developerId, Long creditsRate);
    
    /**
     * 修改虚拟商品
     * @param appItem
     * @param preRemaining
     * @param remaining
     * @param isOnSale
     * @return
     */
    public DubboResult<AppItemDto> doUpdateVirtual(AppItemDto appItem, Integer preRemaining, Integer remaining, boolean isOnSale);
    
    /**
     * 删除开发者商品
     * @param appId
     * @param appItemId
     * @return
     */
    public DubboResult<Boolean> deleteAppItem(Long appId, Long appItemId);
    
    /**
     * 根据运费模板ID查询
     * @param expressTemplateId
     * @return
     */
    public DubboResult<List<AppItemDto>> findAllByExpressTemplateId(Long expressTemplateId);
    
    /**
     * 查询APP所有的虚拟商品
     * @param appId
     * @return
     */
    public DubboResult<List<AppItemDto>> findAllVirtualValid(Long appId);
    
    /**
     * 根据兑吧商品ID查询
     * @param appId
     * @param itemId
     * @return
     */
    public DubboResult<AppItemDto> findByAppIdAndItemId(Long appId, Long itemId);

    /**
     * findAppItemLimit
     * @param param
     * @param start
     * @param pageSize
     * @return
     */
    public DubboResult<List<AppItemDto>> findAppItemLimit(Map<String, Object> param, int start, int pageSize);
    
    /**
     * findAppItemCount
     * @param param
     * @return
     */
    public DubboResult<Long> findAppItemCount(Map<String, Object> param);

    /**
     * APP商品首页排序
     * @param appId
     * @param appItemId
     * @param startPayload
     * @param endPayload
     */
    public DubboResult<Void> sortByAppItemIdAndRange(Long appId, Long appItemId, Integer startPayload, Integer endPayload);
    
    /**
     * 修改limit为null
     * @param appItemId
     * @param limitCount
     * @param limitTimeBetween
     * @param limitEverydayQuantity
     */
    public DubboResult<Void> setLimitNull(Long appItemId, Integer limitCount, String limitTimeBetween, Integer limitEverydayQuantity);
    
    /**
     * updateAutoOffDateNull
     * @param id
     * @return
     */
    public DubboResult<Integer> updateAutoOffDateNull(Long id);
    
    /**
     * findAllByAppAndIsOwner
     * @param appId
     * @param isOwner
     * @return
     */
    public DubboResult<List<AppItemDto>> findAllByAppAndIsOwner(Long appId, Boolean isOwner);
    
    /**
     * selectHasUpItems
     * @param ids
     * @param appId
     * @return
     */
    public DubboResult<List<Long>> selectHasUpItems(List<Long> ids, Long appId);
    
    /**
     * 修改优惠券
     * @param appItem
     * @param exchangeLimit
     * @param arealimitSwitch
     * @param arealimitType
     * @param arealimitAreas
     * @param usePrompt
     * @param btnText
     */
    public DubboResult<Long> doUpdateCoupon(AppItemDto appItem, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas, String usePrompt, String btnText);
    
    /**
     * 根据itemIds in 和 appId
     * @param itemIds
     * @param appId
     * @return
     */
    public DubboResult<List<AppItemDto>> findAllByItemIdsAndAppId(List<Long> itemIds, Long appId);
    
    /**
     * findByAppAndItemOnline
     * @param appId
     * @param itemId
     * @return
     */
    public DubboResult<AppItemDto> findByAppAndItemOnline(Long appId, Long itemId);

	DubboResult<List<AppItemDto>> findAllByIds(List<Long> ids);

	DubboResult<List<AppItemDto>> getByItemId(Long itemId);

	/**
	 *
	 * @param query
	 * @param start
	 * @param pageSize
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAppItemNoExistClassify(Map<String, Object> query, Integer start, Integer pageSize);

	/**
	 * 根据自定义分类查找自有商品
	 * @param classifyId 分类id
	 * @param appId app id
	 * @param status
	 * @return
	 */
	DubboResult<List<AppItemDto>> findClassifyAppItems(Long classifyId, Long appId, String status);

    /**
     * 查询app所有兑换项
     */
    public List<AppItemDto> findAllAppItem(Map<String, Object> param);

    /**
     * 根据appId查询
     */
    public List<AppItemDto> findAllByAppId(Long appId);


	DubboResult<Integer> findAppItemNoExistClassifyCount(Map<String, Object> query, Integer start, Integer pageSize);

	/**
	 * 根据classifyId, appId查找AppItem
	 * @param appId
	 * @param classifyId
	 * @return
	 */
	DubboResult<List<AppItemDto>> findHomeClassifyAppItems(Long appId, Long classifyId);

	public void updateSubTypeById(Long appItemId, Integer subType);

	public void updateValidEndDate(Long appItemId, Date date);

	public void updateExpiedAppItemById(Long appItemId);

	DubboResult<List<Long>> findIdByVirtaulType(Long appId);

	/**
	 * 删除运营活动兑换项
	 */
	DubboResult<Integer> updateStatusByOperationActivityId(String status, Boolean delete, Long relationId);

	DubboResult<List<AppItemDto>> findAutoOffAppItem();

	/**
	 * 更新运营活动状态
	 */
	DubboResult<Integer> updateOperationsTypeById(Long id, Integer operationsType);

	DubboResult<Integer> updateStatusAndSubStatusByItemId(Long itemId, String status, String subStatus);

	/**
	 * 查询自有过期产品（7天 < valid_end_date < new Date）
	 */
	DubboResult<List<AppItemDto>> findSelfOverdueAppItem(String type);

	DubboResult<Integer> updateStatusAndSubStatusById(Long id, String status, String subStatus);

	/**
	 * 计划任务用查询是否在库中
	 */
	DubboResult<AppItemDto> selectItemStore4Task(Long appId, Long itemId);

	/**
	 * 开发者秒杀商品列表
	 * @param appId
	 * @return
     */
	DubboResult<List<AppItemDto>> findSecKillAppItem(Long appId);

	/**
	 * 根据ID集合查询应用商品信息
	 *
	 * @param ids
	 * @param deleted 删除状态，为null表示不管状态
	 * @return
	 */
	List<AppItemDto> findByIds(List<Long> ids, Boolean deleted);

	/**
	 * 新的修改虚拟商品的接口,支持低于屏蔽
	 * @param appItem
	 * @param preRemaining
	 * @param remaining
	 * @param isOnSale
	 * @param exchangeLimit
	 * @param arealimitSwitch
	 * @param arealimitType
	 * @param arealimitAreas
	 * @return
	 */
	AppItemDto doUpdateVirtual2(AppItemDto appItem, Integer preRemaining, Integer remaining, boolean isOnSale,String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas);

}
