package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;
import java.util.Date;

/**
 * AppItemMaskingDto
 */
public class AppItemMaskingDto implements Serializable {
    private static final long serialVersionUID = 22312362895L;

    private Long id;
    private Long appId;
    private Long itemId;

    private Date gmtCreate;
    private Date gmtModified;

    public AppItemMaskingDto(boolean init4insert) {
        if (init4insert) {
            gmtCreate = new Date();
            gmtModified = new Date();
        }
    }

    public AppItemMaskingDto() {
    }

    public AppItemMaskingDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    public void beforeUpdate() {
        gmtModified = new Date();
    }


    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }


    public Long getAppId() {
        return appId;
    }


    public void setAppId(Long appId) {
        this.appId = appId;
    }


    public Long getItemId() {
        return itemId;
    }


    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }


    public Date getGmtCreate() {
        return gmtCreate;
    }


    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }


    public Date getGmtModified() {
        return gmtModified;
    }


    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
