package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;

/**
 * 商品拓展信息类，底层用键值实现
 * Created by hww on 2018/4/25 下午4:21.
 */
public class ItemNewExtraDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 集卡商品类型 */
    public static final String COLLECT_GOODS_TYPE = "collectGoodsType";
    /** 集卡红包 红包类型 */
    public static final String REWARD_TYPE = "rewardType";
    /** 集卡商品活动中奖限制 */
    public static final String PRIZE_LIMIT = "prizeLimit";

    /** 集卡商品类型
     * 0:普通集卡 1:随机红包
     * @see cn.com.duiba.goods.center.api.remoteservice.enums.CollectGoodsTypeEnum
     * */
    private Integer collectGoodsType;

    /**
     * 随机红包类型
     * 当集卡类型collectGoodsType = 1时,必须存在此配置
     * 0:全局红包 1:手气红包
     * @see cn.com.duiba.goods.center.api.remoteservice.enums.RandomRewardTypeEnum
     * */
    private Integer rewardType;

    /**
     * 中奖限制
     * json字段
     * @see cn.com.duiba.goods.center.api.remoteservice.param.CollectGoodsPrizeLimitParam
     */
    private String prizeLimit;

    public Integer getCollectGoodsType() {
        return collectGoodsType;
    }

    public void setCollectGoodsType(Integer collectGoodsType) {
        this.collectGoodsType = collectGoodsType;
    }

    public Integer getRewardType() {
        return rewardType;
    }

    public void setRewardType(Integer rewardType) {
        this.rewardType = rewardType;
    }

    public String getPrizeLimit() {
        return prizeLimit;
    }

    public void setPrizeLimit(String prizeLimit) {
        this.prizeLimit = prizeLimit;
    }
}
