package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by xiaoxuda on 2016/11/17. 
 * 商品地域限制服务
 */
@AdvancedFeignClient
public interface RemoteAddrLimitService {

	/**
	 * 返回参数中能通过地域限制的商品项，ip为空且商品的地域限制开关打开时商品不可用
	 * 
	 * @param items
	 * @param ip
	 * @return
	 */
	public DubboResult<List<ItemKeyDto>> getItemCanPassAddrLimit(List<ItemKeyDto> items, String ip);

	/**
	 * IP地址兑换限制验证
	 * 
	 * @return
	 */
	public DubboResult<Boolean> ipValidation(ItemKeyDto itemKeyDto, String ip);

	/**
	 * 查询商品地域限制
	 * @param gtype
	 * @param gid
	 * @return
	 */
	public DubboResult<List<AddrLimitDto>> findAddrLimitByGid(GoodsTypeEnum gtype, Long gid);

	/**
	 * 批量查询商品地域限制
	 * @param gtype
	 * @param gid
	 * @return
	 */
	public DubboResult<List<AddrLimitDto>> findAddrLimitByGids(GoodsTypeEnum gtype,List<Long>  gid);
	/**
	 * 查询type
	 * @param gtype
     * @param gid
	 * @return
	 */
	public DubboResult<Integer> findTypeByGid(GoodsTypeEnum gtype, Long gid);

	/**
	 * 批量添加
	 * @param addrLimitList
	 * @return 添加条数
	 */
	public DubboResult<Integer> batchInsertAddrLimit(List<AddrLimitDto> addrLimitList);

	/**
	 * 删除商品地域限制
	 * @param itemId
	 * @param appItemId
	 * @return 删除条数
	 */
	public DubboResult<Integer> deleteAddrLimit(Long itemId, Long appItemId);
	
	
}
