package cn.com.duiba.goods.center.api.remoteservice.front;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ImmediatelyButtonDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 马上使用按钮获取信息接口
 */
@AdvancedFeignClient
public interface RemoteImmediatelyButtonService {
	/**
	 * selectImmediatelyButtonFromItem:马上使用按钮跳转链接. <br/>
	 *
	 * @author guoeryang
	 * @param gid
	 * @param gtype
	 *            0:兑吧商品 1：自有商品 2：券库
	 * @param userAgent
	 *            请求端类型
	 * @param hdtoolFalg
	 *            活动表示 1表示 活动页面 2 兑换详情页
	 * @param urlParameter
	 *            生成曝光链接用 （为空时 ：不生成 埋点url）
	 * @param embedClickurl
	 *            埋点服务器地址（为空时 ：不生成 埋点url）
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<String> selectImmediatelyButton(Long gid, GoodsTypeEnum gtype, Long orderId, String userAgent, String hdtoolFalg, String urlParameter, String embedClickurl);

	/**
	 * selectImmediatelyButtonFromCoupon:马上使用按钮跳转链接. <br/>
	 *
	 * @author guoeryang
	 * @param couponId
	 * @param itemId
	 * @param orderId
	 * @param urlParameter
	 *            生成曝光链接用 （为空时 ：不生成 埋点url）
	 * @param embedClickurl
	 *            埋点服务器地址（为空时 ：不生成 埋点url）
	 * @param hdtoolFalg
	 *            活动表示 1表示 活动页面 2 兑换详情页
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<String> selectImmediatelyButtonFromCoupon(Long couponId, Long itemId, Long orderId, String urlParameter, String embedClickurl, String hdtoolFalg);

	/**
	 * selectImmediatelyButtonFromItem:马上使用按钮跳转链接. <br/>
	 *
	 * @author guoeryang
	 * @param gid
	 * @param gtype
	 *            0:兑吧商品 1：自有商品 2：券库
	 * @param userAgent
	 *            请求端类型
	 * @param hdtoolFalg
	 *            活动表示 1表示 活动页面 2 兑换详情页
	 * @param urlParameter
	 *            生成曝光链接用 （为空时 ：不生成 埋点url）
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<ImmediatelyButtonDto> selectImmediatelyForPlatfrom(Long gid, GoodsTypeEnum gtype, Long orderId, String userAgent, String hdtoolFalg, String consunmerId);

	/**
	 * 查询立即使用按钮
	 * @param itemId
	 * @return
     */
	DubboResult<Integer> findImmediatelyButtonById(Long itemId);

}
