package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import cn.com.duiba.dcommons.enums.AppItemSourceTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.BaseImgDto;

import java.io.Serializable;
import java.util.Date;

/**
 * 开发者商品DTO
 */
public class AppItemDto extends BaseImgDto implements Serializable {

	private static final long serialVersionUID = 8735456901927646152L;

	/** 上架状态 */
	public static final String StatusOn = "on";
	/** 下架状态 */
	public static final String StatusOff = "off";
	/** 子状态（expired：已过期） */
	public static final String SubStatusExpired = "expired";

	/** 运费类型 包邮 */
	public static final String ExpressTypeFree = "free";
	/** 运费类型 统一运费 */
	public static final String ExpressTypeUnity = "unity";
	/** 运费类型 模板 */
	public static final String ExpressTypeTemplate = "template";

	/** 普通兑换 */
	public static final int SourceTypeNormal = AppItemSourceTypeEnum.SourceTypeNormal.getCode();
	/** 运营活动创建的AppItem */
	public static final int SourceTypeOperatingActivity = AppItemSourceTypeEnum.SourceTypeOperatingActivity.getCode();
	/** 兑吧专题活动 */
	public static final int SourceTypeDuibaActivity = AppItemSourceTypeEnum.SourceTypeDuibaActivity.getCode();
	/** 单品抽奖活动 */
	public static final int SourceTypeSingleLottery = AppItemSourceTypeEnum.SourceTypeSingleLottery.getCode();
	/** 手动开奖活动 */
	public static final int SourceTypeManualLottery = AppItemSourceTypeEnum.SourceTypeManualLottery.getCode();
	/** 专题活动的兑换项入口 */
	public static final int SourceTypeDuibaActivityItem = AppItemSourceTypeEnum.SourceTypeDuibaActivityItem.getCode();
	/** 专题活动的单品抽奖的兑换项入口 */
	public static final int SourceTypeDuibaActivitySingleLottery = AppItemSourceTypeEnum.SourceTypeDuibaActivitySingleLottery.getCode();
	/** 摇一摇抽奖 */
	public static final int SourceTypeAppShakeLottery = AppItemSourceTypeEnum.SourceTypeAppShakeLottery.getCode();
	/** 刮刮卡抽奖 */
	public static final int SourceTypeAppScratchCardLottery = AppItemSourceTypeEnum.SourceTypeAppScratchCardLottery.getCode();
	/** 老虎机 */
	public static final int SourceTypeHdtoolTiger = AppItemSourceTypeEnum.SourceTypeHdtoolTiger.getCode();
	/** 趣味翻牌 */
	public static final int SourceTypeHdtoolFlop = AppItemSourceTypeEnum.SourceTypeHdtoolFlop.getCode();
	/** 砸彩蛋 */
	public static final int SourceTypeHdtoolSmashg = AppItemSourceTypeEnum.SourceTypeHdtoolSmashg.getCode();
	/** 活动工具大转盘 */
	public static final int SourceTypeHdtoolTurntable = AppItemSourceTypeEnum.SourceTypeHdtoolTurntable.getCode();
	/** 秒杀专题 */
	public static final int SourceTypeSecondsKill = AppItemSourceTypeEnum.SourceTypeSecondsKill.getCode();
	/** 游戏，打劫圣诞老人 */
	public static final int SourceTypeGameSanta = AppItemSourceTypeEnum.SourceTypeGameSanta.getCode();
	/** 游戏，数年终奖 */
	public static final int SourceTypeGameYearAward = AppItemSourceTypeEnum.SourceTypeGameYearAward.getCode();
	/** 游戏，女神pk */
	public static final int SourceTypeGameGirl = AppItemSourceTypeEnum.SourceTypeGameGirl.getCode();
	/** 游戏，人在囧途 */
	public static final int SourceTypeGameJiong = AppItemSourceTypeEnum.SourceTypeGameJiong.getCode();
	/** 兑吧答题活动 */
	public static final int SourceTypeDuibaQuestionAnswer = AppItemSourceTypeEnum.SourceTypeDuibaQuestionAnswer.getCode();
	/** 兑吧测试题活动 */
	public static final int SourceTypeDuibaQuizz = AppItemSourceTypeEnum.SourceTypeDuibaQuizz.getCode();
	/** 兑吧秒杀活动 */
	public static final int SourceTypeDuibaSeckill = AppItemSourceTypeEnum.SourceTypeDuibaSeckill.getCode();
	/** 兑吧新游戏 */
	public static final int SourceTypeDuibaNgame = AppItemSourceTypeEnum.SourceTypeDuibaNgame.getCode();
	/** 兑吧竞猜 */
	public static final int SourceTypeDuibaGuess = AppItemSourceTypeEnum.SourceTypeDuibaGuess.getCode();
	/** 新游戏 */
	public static final int SourceTypeNgame = AppItemSourceTypeEnum.SourceTypeNgame.getCode();
	/** 竞猜 */
	public static final int SourceTypeGuess = AppItemSourceTypeEnum.SourceTypeGuess.getCode();

	/** 会员等级限制类型 0 说明该兑换项没有配置会员等级限制 */
	public static final int OFF_LEVEL = 0;
	/** 会员等级限制类型 1 精确限制 */
	public static final int ACCURATE_LEVEL = 1;
	/** 会员等级限制类型 2 以上的限制 */
	public static final int ABOVE_LEVEL = 2;
	
	/** 置顶项的起始权重 @author liuyao */
	public static final int ITEM_TOP_START = 1000000;
	/** 每个APP可以置顶数目 @author liuyao */
	public static final int ITEM_TOP_NUM = 3;

	// Start chaijiangang,幸运转盘改为活动工具,2016/04/12
	public static final String SourceTypeAppShakeLottery_Action = "shake";// 摇一摇抽奖
	public static final String SourceTypeAppScratchCardLottery_Action = "ScratchCard";// 刮刮卡抽奖
	public static final String SourceTypeHdtoolTiger_Action = "tiger";// 老虎机
	public static final String SourceTypeHdtoolTurntable_Action = "turntableNew";// 活动工具大转盘
	public static final String SourceTypeHdtoolFlop_Action = "flop";// 活动工具趣味翻牌
	public static final String SourceTypeHdtoolSmashg_Action = "smashg";// 活动工具砸金蛋
	// End chaijiangang,幸运转盘改为活动工具,2016/04/12

	// Start guoeryang,开发者可编辑兑吧活动的抽奖积分,2016/05/03
	public static final int SwitchExchangeCreditsType = 16;// 可编辑抽奖积分
	// End guoeryang,开发者可编辑兑吧活动的抽奖积分,2016/05/03

	// Start guoeryang,直充类奖品防刷,2016/06/14
	public static final int SwitchExchangeLimitType = 18; // 商品防刷
	// End guoeryang,直充类奖品防刷,2016/06/14

	private Long id;
	private Long appId;
	private Long itemId;
	private Long batchId;
	private Long credits;
	private Integer minFacePrice;
	private String logo;
	private String title;
	private String subtitle;
	private Integer payload;
	private String customPrice;
	private Date addTime;
	private Boolean deleted;
	private String status;
	private String subStatus;
	private Boolean homeDisplay;
	private Boolean isOwner;
	private String exchangeTipTemplate;
	private String alertMessage;
	private String description;
	private Integer facePrice;
	private Integer limitCount;
	//当前库存
	private Integer remaining;
	private Date validEndDate;
	private String smallImage;
	private String whiteImage;
	private String image;
	private String multiImage;
	private String type;
	private Integer sourceType;
	private Long sourceRelationId;
	private String limitScope;
	private Integer operationsType;
	private String limitTimeBetween;
	private Integer limitEverydayQuantity;
	private String bannerImage;
	private String limitDate;
	private String customTag;
	private Integer subType;
	private Date gmtCreate;
	private Date gmtModified;
	private Long vipLimits;
	private Integer vipLimitType;
	private Date autoOffDate;
	private String devCustomCode;
	private Long salePrice;
	private String expressType;
	private Long expressPrice;
	private Long expressTemplateId;
	private Long sellerId;
	private Long classifyId;
	private Integer classifyPayload;
	//扩展json信息,目前用来存储了摩拜的积分信息
	private String extraInfo;

	private Long stockId;//关联库存中心的stockId

	/**
	 * is_series，是否系列商品
	 */
	private Integer isSeries;
	public AppItemDto() {
	}

	public AppItemDto(boolean init4insert) {
		if (init4insert) {
			facePrice = 0;
			isOwner = false;
			homeDisplay = true;
			deleted = false;
			sourceType = SourceTypeNormal;
			payload = 0;
			operationsType = 0;
			subStatus = "";
			gmtCreate = new Date();
			gmtModified = new Date();
			limitScope = ItemDto.LimitTypeForever;
			vipLimits = 0L;
			vipLimitType = 0;
		}
	}
	
	public AppItemDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 * @deprecated 直接在DTO中进行开关的切换比较危险,请直接使用SwitchUtils
	 * @param opType
	 */
	@Deprecated
	public void grantOpTypeAppItem(int opType) {
		int v = 1 << opType;
		this.operationsType = this.operationsType | v;
	}

	/**
	 * @deprecated
	 * @param opType
	 */
	@Deprecated
	public void ungrantOpTypeAppItem(int opType) {
		int v = 1 << opType;
		v = ~v;
		this.operationsType = this.operationsType & v;
	}

	/**
	 * isOpTypeAppItem
	 * 
	 * @param opType
	 * @return
	 */
	public boolean isOpTypeAppItem(int opType) {
		int v = 1 << opType;
		int ret = this.operationsType & v;
		return ret != 0;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getBatchId() {
		return batchId;
	}

	public void setBatchId(Long batchId) {
		this.batchId = batchId;
	}

	public Long getCredits() {
		return credits;
	}

	public void setCredits(Long credits) {
		this.credits = credits;
	}

	public Integer getMinFacePrice() {
		return minFacePrice;
	}

	public void setMinFacePrice(Integer minFacePrice) {
		this.minFacePrice = minFacePrice;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getSubtitle() {
		return subtitle;
	}

	public void setSubtitle(String subtitle) {
		this.subtitle = subtitle;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public String getCustomPrice() {
		return customPrice;
	}

	public void setCustomPrice(String customPrice) {
		this.customPrice = customPrice;
	}

	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getSubStatus() {
		return subStatus;
	}

	public void setSubStatus(String subStatus) {
		this.subStatus = subStatus;
	}

	public Boolean getHomeDisplay() {
		return homeDisplay;
	}

	public void setHomeDisplay(Boolean homeDisplay) {
		this.homeDisplay = homeDisplay;
	}

	public Boolean getOwner() {
		return isOwner;
	}

	public void setOwner(Boolean owner) {
		isOwner = owner;
	}

	public Boolean getIsOwner() {
		return isOwner;
	}

	public void setIsOwner(Boolean owner) {
		isOwner = owner;
	}

	public String getAlertMessage() {
		return alertMessage;
	}

	public void setAlertMessage(String alertMessage) {
		this.alertMessage = alertMessage;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(Integer facePrice) {
		this.facePrice = facePrice;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public Integer getRemaining() {
		return remaining;
	}

	public void setRemaining(Integer remaining) {
		this.remaining = remaining;
	}

	public Date getValidEndDate() {
		return validEndDate;
	}

	public void setValidEndDate(Date validEndDate) {
		this.validEndDate = validEndDate;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getMultiImage() {
		return multiImage;
	}

	public void setMultiImage(String multiImage) {
		this.multiImage = multiImage;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getSourceType() {
		return sourceType;
	}

	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	public Long getSourceRelationId() {
		return sourceRelationId;
	}

	public void setSourceRelationId(Long sourceRelationId) {
		this.sourceRelationId = sourceRelationId;
	}

	public String getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(String limitScope) {
		this.limitScope = limitScope;
	}

	public Integer getOperationsType() {
		return operationsType;
	}

	public void setOperationsType(Integer operationsType) {
		this.operationsType = operationsType;
	}

	public String getLimitTimeBetween() {
		return limitTimeBetween;
	}

	public void setLimitTimeBetween(String limitTimeBetween) {
		this.limitTimeBetween = limitTimeBetween;
	}

	public Integer getLimitEverydayQuantity() {
		return limitEverydayQuantity;
	}

	public void setLimitEverydayQuantity(Integer limitEverydayQuantity) {
		this.limitEverydayQuantity = limitEverydayQuantity;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public String getLimitDate() {
		return limitDate;
	}

	public void setLimitDate(String limitDate) {
		this.limitDate = limitDate;
	}

	public String getCustomTag() {
		return customTag;
	}

	public void setCustomTag(String customTag) {
		this.customTag = customTag;
	}

	public Integer getSubType() {
		return subType;
	}

	public void setSubType(Integer subType) {
		this.subType = subType;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getVipLimits() {
		return vipLimits;
	}

	public void setVipLimits(Long vipLimits) {
		this.vipLimits = vipLimits;
	}

	public Integer getVipLimitType() {
		return vipLimitType;
	}

	public void setVipLimitType(Integer vipLimitType) {
		this.vipLimitType = vipLimitType;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public String getDevCustomCode() {
		return devCustomCode;
	}

	public void setDevCustomCode(String devCustomCode) {
		this.devCustomCode = devCustomCode;
	}

	public Long getSalePrice() {
		return salePrice;
	}

	public void setSalePrice(Long salePrice) {
		this.salePrice = salePrice;
	}

	public String getExpressType() {
		return expressType;
	}

	public void setExpressType(String expressType) {
		this.expressType = expressType;
	}

	public Long getExpressPrice() {
		return expressPrice;
	}

	public void setExpressPrice(Long expressPrice) {
		this.expressPrice = expressPrice;
	}

	public Long getExpressTemplateId() {
		return expressTemplateId;
	}

	public void setExpressTemplateId(Long expressTemplateId) {
		this.expressTemplateId = expressTemplateId;
	}

	public Long getSellerId() {
		return sellerId;
	}

	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public Long getClassifyId() {
		return classifyId;
	}

	public void setClassifyId(Long classifyId) {
		this.classifyId = classifyId;
	}

	public Integer getClassifyPayload() {
		return classifyPayload;
	}

	public void setClassifyPayload(Integer classifyPayload) {
		this.classifyPayload = classifyPayload;
	}

	/**
	 * exchangeTipTemplate.
	 *
	 * @return the exchangeTipTemplate
	 */
	public String getExchangeTipTemplate() {
		return exchangeTipTemplate;
	}

	/**
	 * exchangeTipTemplate.
	 *
	 * @param exchangeTipTemplate
	 *            the exchangeTipTemplate to set
	 */
	public void setExchangeTipTemplate(String exchangeTipTemplate) {
		this.exchangeTipTemplate = exchangeTipTemplate;
	}

	public String getExtraInfo() {
		return extraInfo;
	}

	public void setExtraInfo(String extraInfo) {
		this.extraInfo = extraInfo;
	}

	public Long getStockId() {
		return stockId;
	}

	public void setStockId(Long stockId) {
		this.stockId = stockId;
	}

	public Integer getIsSeries() {
		return isSeries;
	}

	public void setIsSeries(Integer isSeries) {
		this.isSeries = isSeries;
	}
}
