/**
 * Project Name:goods-center-api
 * File Name:RemotePCGGoodsInfoService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年6月29日下午8:53:46
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFloorDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.pcg.PcgDetailDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemotePCGGoodsInfoService <br/>
 * Function: 平台券商品信息查询. <br/>
 * Date:     2016年6月29日 下午8:53:46 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemotePCGGoodsInfoService {
    /**
     * 查询商品(不包含已删除的商品)
     *
     * @author xuhengfei
     * @param pcgId 商品id
     * @return 商品信息
     * @since JDK 1.6
     */
    public PCGDto find(long pcgId);
    
    /**
     * 提供给详情页的查询接口
     * @param pcgId
     * @param appId
     * @return
     */
    public DubboResult<PcgDetailDto> findForDetail(long pcgId,long appId);
    /**
     * 查询商品(包含已经删除的商品)
     *
     * @author xuhengfei
     * @param pcgId 商品id
     * @return 商品信息
     * @since JDK 1.6
     */
    public PCGDto findIncludeDeleted(long pcgId);
    /**
     * 
     * findCategoryAll:查询所有的分类 <br/>
     *
     * @author zhengjy
     * @return 结果集
     * @since JDK 1.6
     */
    DubboResult<List<PCGCategoryDto>> findCategoryAll();
    /**
     * 
     * findSellerAll:查询所有品牌 <br/>
     *
     * @author zhengjy
     * @return 结果集
     * @since JDK 1.6
     */
    DubboResult<List<PCGSellerDto>> findSellerAll();
    
   
    /**
     * 查询app下屏蔽分类，品牌或商品 <br/>
     * @param appId 
     * @param type  type  1:优惠券 2:分类 3:品牌
     * @return 结果集
     */
    DubboResult<List<Long>>  findPCGFilterTargetIds(Long appId,Integer type);
    
    /**
     * 查询分类下商品列表<br/>
     * @param appId
     * @param categoryId
     * @param consumerId 用户id
     * @param consumerCredits 用户积分
     * @param pageIndex 页码
     * @param pageSize 分页大小
     * @return 分页结果集
     */
    DubboResult<Page<PCGCategorySellerGoodsDto>> findCategoryGoods(long appId,long categoryId,Long consumerId,Long consumerCredits, Integer pageIndex, Integer pageSize);
    
    /**
     * 查询品牌下商品列表<br/>
     * @param appId
     * @param sellerId
     * @param consumerId 用户id
     * @param consumerCredits 用户积分
     * @param pageIndex 页码
     * @param pageSize 分页大小
     * @return 分页结果集
     */
    DubboResult<Page<PCGCategorySellerGoodsDto>> findSellerGoods(long appId,long sellerId,Long consumerId,Long consumerCredits, Integer pageIndex, Integer pageSize);

    /**
     * 获取所有可展示的平台券
     * 获取逻辑,取每个分类的前两个,但是为过滤做预留,每个分类下取4个
     * 如果App下有3个优惠券分类项,则加载 3*4 = 12
     * @param appId
     * @param appTags
     * @return
     */
    DubboResult<List<PCGFloorDto>> findAllPcg4Floor(Long appId,String appTags);
}

