/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.sku.SkuAttributeNode;
import cn.com.duiba.goods.center.api.remoteservice.tool.SkuResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractSkuResolver<T, R extends Serializable>
implements SkuResolver<T, R> {
    private static final String ATTRIBUTE_SEPARATOR = ":";
    private static final String ATTRIBUTE_GROUP_SEPARATOR = ";";
    private static final Long DEFAULT_ATTRIBUTE_ID = 0L;
    private static final Long DEFAULT_ATTRIBUTE_VALUE_ID = 0L;

    @Override
    public List<T> resolveNodes(Long appItemId, Long itemId, List<SkuAttributeNode<R>> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Collections.emptyList();
        }
        ArrayList skuList = new ArrayList();
        for (SkuAttributeNode<R> node : nodes) {
            this.resolveNode(appItemId, itemId, skuList, "", node);
        }
        return skuList;
    }

    @Override
    public List<T> resolveNode(Long appItemId, Long itemId, SkuAttributeNode<R> node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList skuList = new ArrayList();
        this.resolveNode(appItemId, itemId, skuList, "", node);
        return skuList;
    }

    private void resolveNode(Long appItemId, Long itemId, List<T> skuList, String attributeJson, SkuAttributeNode<R> node) {
        Long attrId = NumberUtils.toLong((String)node.getSpecId(), (long)DEFAULT_ATTRIBUTE_ID);
        Long valueId = NumberUtils.toLong((String)node.getId(), (long)DEFAULT_ATTRIBUTE_VALUE_ID);
        if (CollectionUtils.isEmpty(node.getChildren())) {
            R skuInfo = this.getSkuInfo(node);
            if (skuInfo != null) {
                attributeJson = StringUtils.join((Object[])new Serializable[]{attributeJson, attrId, ATTRIBUTE_SEPARATOR, valueId});
                skuList.add(this.newSkuInstance(appItemId, itemId, attributeJson, skuInfo));
            }
        } else {
            attributeJson = StringUtils.join((Object[])new Serializable[]{attributeJson, attrId, ATTRIBUTE_SEPARATOR, valueId, ATTRIBUTE_GROUP_SEPARATOR});
            for (SkuAttributeNode<R> child : node.getChildren()) {
                child.setImgUrl(node.getImgUrl());
                this.resolveNode(appItemId, itemId, skuList, attributeJson, child);
            }
        }
    }

    protected R getSkuInfo(SkuAttributeNode<R> node) {
        return node.getSkuInfo();
    }

    protected abstract T newSkuInstance(Long var1, Long var2, String var3, R var4);

    @Override
    public List<SkuAttributeNode<R>> reverse(List<T> skuList) {
        if (CollectionUtils.isEmpty(skuList)) {
            return Collections.emptyList();
        }
        ArrayList<SkuAttributeNode<R>> nodes = new ArrayList<SkuAttributeNode<R>>();
        for (T sku : skuList) {
            this.reverseSku(sku, nodes);
        }
        return nodes;
    }

    protected abstract String getAttributeJson(T var1);

    protected abstract R newSkuInfo(T var1);

    private void reverseSku(T sku, List<SkuAttributeNode<R>> nodes) {
        String attributeJson = this.getAttributeJson(sku);
        String[] groups = attributeJson.split(ATTRIBUTE_GROUP_SEPARATOR);
        SkuAttributeNode<R> prevNode = null;
        SkuAttributeNode<R> headNode = null;
        int last = groups.length - 1;
        for (int i = 0; i < groups.length; ++i) {
            boolean isLeaf;
            String[] attrs = groups[i].split(ATTRIBUTE_SEPARATOR);
            String attrId = attrs[0];
            String valueId = attrs[1];
            boolean bl = isLeaf = i >= last;
            if (prevNode == null) {
                headNode = prevNode = this.getOrCreateNode(attrId, valueId, sku, nodes, isLeaf);
            } else {
                prevNode = this.getOrCreateNode(attrId, valueId, sku, prevNode.getChildren(), isLeaf);
            }
            this.postNode(headNode, prevNode);
        }
    }

    protected void postNode(SkuAttributeNode<R> headNode, SkuAttributeNode<R> node) {
    }

    private SkuAttributeNode<R> getOrCreateNode(String attrId, String valueId, T sku, List<SkuAttributeNode<R>> nodes, boolean isLeaf) {
        SkuAttributeNode<R> node = this.getNode(valueId, nodes);
        if (node == null) {
            node = this.newNode(attrId, valueId, sku, isLeaf);
            nodes.add(node);
        }
        return node;
    }

    private SkuAttributeNode<R> getNode(String valueId, List<SkuAttributeNode<R>> nodes) {
        for (SkuAttributeNode<R> node : nodes) {
            if (!Objects.equals(valueId, node.getId())) continue;
            return node;
        }
        return null;
    }

    private SkuAttributeNode<R> newNode(String specId, String valueId, T sku, boolean isLeaf) {
        SkuAttributeNode<Object> node = new SkuAttributeNode<Object>();
        node.setId(valueId);
        node.setSpecId(specId);
        if (!isLeaf) {
            node.setChildren(new ArrayList());
        } else {
            node.setSkuInfo(this.newSkuInfo(sku));
        }
        return node;
    }

    protected Long parseString2Long(String value) {
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(value.trim());
    }

    protected String parseLong2String(Long value) {
        return value == null ? null : value.toString();
    }
}

