/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AppItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.SkuAttributeNode;
import cn.com.duiba.goods.center.api.remoteservice.tool.AbstractSkuResolver;
import cn.com.duiba.goods.center.api.remoteservice.tool.UnitUtils;

public class AppItemSkuResolver
extends AbstractSkuResolver<AppItemSkuDto, SkuAttributeNode.SkuInfo> {
    @Override
    protected AppItemSkuDto newSkuInstance(Long appItemId, Long itemId, String attributeJson, SkuAttributeNode.SkuInfo skuInfo) {
        AppItemSkuDto appItemSku = new AppItemSkuDto();
        appItemSku.setAppItemId(appItemId);
        appItemSku.setItemId(itemId);
        appItemSku.setAttributeJson(attributeJson);
        appItemSku.setId(this.parseString2Long(skuInfo.getId()));
        appItemSku.setFacePrice(UnitUtils.transformYuan2Fen(skuInfo.getFacePrice()));
        appItemSku.setSalePrice(UnitUtils.transformYuan2Fen(skuInfo.getSalePrice()));
        appItemSku.setMerchantCoding(skuInfo.getMerchantCoding());
        appItemSku.setRemaining(skuInfo.getRemaining());
        appItemSku.setImgUrl(skuInfo.getImgUrl());
        appItemSku.setStockId(this.parseString2Long(skuInfo.getStockId()));
        return appItemSku;
    }

    @Override
    protected String getAttributeJson(AppItemSkuDto sku) {
        return sku.getAttributeJson();
    }

    @Override
    protected SkuAttributeNode.SkuInfo newSkuInfo(AppItemSkuDto sku) {
        SkuAttributeNode.SkuInfo skuInfo = new SkuAttributeNode.SkuInfo();
        skuInfo.setId(this.parseLong2String(sku.getId()));
        skuInfo.setFacePrice(UnitUtils.transformFen2Yuan(sku.getFacePrice()));
        skuInfo.setSalePrice(UnitUtils.transformFen2Yuan(sku.getSalePrice()));
        skuInfo.setMerchantCoding(sku.getMerchantCoding());
        skuInfo.setImgUrl(sku.getImgUrl());
        skuInfo.setStockId(this.parseLong2String(sku.getStockId()));
        skuInfo.setRemaining(sku.getRemaining());
        return skuInfo;
    }

    @Override
    protected SkuAttributeNode.SkuInfo getSkuInfo(SkuAttributeNode<SkuAttributeNode.SkuInfo> node) {
        SkuAttributeNode.SkuInfo skuInfo = node.getSkuInfo();
        if (skuInfo != null) {
            skuInfo.setImgUrl(node.getImgUrl());
        }
        return super.getSkuInfo(node);
    }

    @Override
    protected void postNode(SkuAttributeNode<SkuAttributeNode.SkuInfo> headNode, SkuAttributeNode<SkuAttributeNode.SkuInfo> node) {
        if (node.getSkuInfo() != null) {
            if (headNode.getImgUrl() == null) {
                headNode.setImgUrl(node.getSkuInfo().getImgUrl());
            }
            node.getSkuInfo().setImgUrl(null);
        }
        super.postNode(headNode, node);
    }
}

