/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.SkuAttributeNode;
import cn.com.duiba.goods.center.api.remoteservice.tool.AbstractSkuResolver;
import cn.com.duiba.goods.center.api.remoteservice.tool.UnitUtils;

public class ItemSkuResolver
extends AbstractSkuResolver<ItemSkuDto, SkuAttributeNode.SkuInfo> {
    @Override
    protected ItemSkuDto newSkuInstance(Long appItemId, Long itemId, String attributeJson, SkuAttributeNode.SkuInfo skuInfo) {
        ItemSkuDto itemSku = new ItemSkuDto();
        itemSku.setItemId(itemId);
        itemSku.setAttributeJson(attributeJson);
        itemSku.setId(this.parseString2Long(skuInfo.getId()));
        itemSku.setFacePrice(UnitUtils.transformYuan2Fen(skuInfo.getFacePrice()));
        itemSku.setSalePrice(UnitUtils.transformYuan2Fen(skuInfo.getSalePrice()));
        itemSku.setMerchantCoding(skuInfo.getMerchantCoding());
        itemSku.setImgUrl(skuInfo.getImgUrl());
        itemSku.setStockId(this.parseString2Long(skuInfo.getStockId()));
        return itemSku;
    }

    @Override
    protected String getAttributeJson(ItemSkuDto sku) {
        return sku.getAttributeJson();
    }

    @Override
    protected SkuAttributeNode.SkuInfo newSkuInfo(ItemSkuDto sku) {
        SkuAttributeNode.SkuInfo skuInfo = new SkuAttributeNode.SkuInfo();
        skuInfo.setId(this.parseLong2String(sku.getId()));
        skuInfo.setFacePrice(UnitUtils.transformFen2Yuan(sku.getFacePrice()));
        skuInfo.setSalePrice(UnitUtils.transformFen2Yuan(sku.getSalePrice()));
        skuInfo.setMerchantCoding(sku.getMerchantCoding());
        skuInfo.setImgUrl(sku.getImgUrl());
        skuInfo.setStockId(this.parseLong2String(sku.getStockId()));
        return skuInfo;
    }

    @Override
    protected SkuAttributeNode.SkuInfo getSkuInfo(SkuAttributeNode<SkuAttributeNode.SkuInfo> node) {
        SkuAttributeNode.SkuInfo skuInfo = super.getSkuInfo(node);
        skuInfo.setImgUrl(node.getImgUrl());
        return skuInfo;
    }

    @Override
    protected void postNode(SkuAttributeNode<SkuAttributeNode.SkuInfo> headNode, SkuAttributeNode<SkuAttributeNode.SkuInfo> node) {
        if (node.getSkuInfo() != null) {
            if (headNode.getImgUrl() == null) {
                headNode.setImgUrl(node.getSkuInfo().getImgUrl());
            }
            node.getSkuInfo().setImgUrl(null);
        }
    }
}

