/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.marketing.MarketingItemCreditsSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AppItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.CreditsSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.ExchangeTypeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MarketingSkuUtils {
    private static final String SEPARATOR_ATTRIBUTE_SEMICOLON = ";";
    private static final String SEPARATOR_ATTRIBUTE_COLON = ":";

    public static List<CreditsSkuDto> getCreditsSkuList(List<AppItemSkuDto> skuList, List<MarketingItemCreditsSkuDto> marketingItemCreditsSkuList, Integer exchangeType, Integer creditsRate) {
        if (null == skuList || skuList.isEmpty() || null == exchangeType) {
            return null;
        }
        ArrayList newSkuList = Lists.newArrayList();
        HashMap<Long, MarketingItemCreditsSkuDto> marketingItemCreditsSkuMap = new HashMap();
        if (marketingItemCreditsSkuList != null && !marketingItemCreditsSkuList.isEmpty()) {
            marketingItemCreditsSkuMap = marketingItemCreditsSkuList.stream().collect(Collectors.toMap(MarketingItemCreditsSkuDto::getSkuId, m -> m, (k1, k2) -> k1));
        }
        for (AppItemSkuDto sku : skuList) {
            CreditsSkuDto skuObj = new CreditsSkuDto();
            skuObj.setSkuId(sku.getId());
            String[] attrArray = sku.getAttributeJson().split(SEPARATOR_ATTRIBUTE_SEMICOLON);
            StringBuffer newSkuStr = new StringBuffer();
            for (String attrStr : attrArray) {
                Integer i = attrStr.indexOf(SEPARATOR_ATTRIBUTE_COLON, attrStr.indexOf(SEPARATOR_ATTRIBUTE_COLON) + 1);
                String newValue = i != -1 ? attrStr.substring(0, attrStr.lastIndexOf(SEPARATOR_ATTRIBUTE_COLON)) : attrStr;
                newSkuStr.append(newValue).append(SEPARATOR_ATTRIBUTE_SEMICOLON);
            }
            skuObj.setAttributeValue(newSkuStr.toString().substring(0, newSkuStr.length() - 1));
            skuObj.setFacePrice(sku.getFacePrice());
            skuObj.setSalePrice(sku.getSalePrice());
            skuObj.setImgUrl(sku.getImgUrl());
            skuObj.setRemaining(sku.getRemaining());
            MarketingSkuUtils.setMarketingInfo(exchangeType, creditsRate, marketingItemCreditsSkuMap, sku, skuObj);
            newSkuList.add(skuObj);
        }
        return newSkuList;
    }

    private static void setMarketingInfo(Integer exchangeType, Integer creditsRate, Map<Long, MarketingItemCreditsSkuDto> marketingItemCreditsSkuMap, AppItemSkuDto sku, CreditsSkuDto skuObj) {
        if (exchangeType.intValue() == ExchangeTypeEnum.AUTOMATIC.getCode().intValue()) {
            skuObj.setMarketingCredits((long)Math.ceil((double)(sku.getSalePrice() * (long)creditsRate.intValue()) / 100.0));
            skuObj.setMarketingPrice(0L);
        } else {
            MarketingItemCreditsSkuDto dto = marketingItemCreditsSkuMap.get(sku.getId());
            skuObj.setMarketingCredits(dto.getCustomCredits());
            skuObj.setMarketingPrice(dto.getCustomPrice());
        }
    }
}

