/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;

public class ItemQueries
implements Serializable {
    private static final int OFFSET_DESC = 1;
    private static final int OFFSET_LIMIT = 2;
    private static final int OFFSET_SKU = 4;
    private static final int OFFSET_CREDITS = 8;
    private static final int OFFSET_CREDITS_SKU = 16;
    private int value;

    public ItemQueries() {
    }

    private ItemQueries(boolean all) {
        if (all) {
            this.value = Integer.MAX_VALUE;
        }
    }

    public static ItemQueries empty() {
        return new ItemQueries();
    }

    public static ItemQueries all() {
        return new ItemQueries(true);
    }

    public ItemQueries withDescConfig() {
        return this.with(1);
    }

    public ItemQueries withLimitConfig() {
        return this.with(2);
    }

    public ItemQueries withSku() {
        return this.with(4);
    }

    public ItemQueries withCredits() {
        return this.with(8);
    }

    public ItemQueries withCreditsSku() {
        return this.with(16);
    }

    private ItemQueries with(int offset) {
        this.value |= offset;
        return this;
    }

    public boolean hasDescConfig() {
        return this.has(1);
    }

    public boolean hasLimitConfig() {
        return this.has(2);
    }

    public boolean hasSku() {
        return this.has(4);
    }

    public boolean hasCredits() {
        return this.has(8);
    }

    public boolean hasCreditsSku() {
        return this.has(16);
    }

    private boolean has(int offset) {
        return (this.value & offset) > 0;
    }
}

