/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import java.io.Serializable;
import java.util.Date;

public class ItemKeyDto
implements Serializable {
    private static final long serialVersionUID = 284762871342171085L;
    protected AppItemDto appItem;
    protected ItemDto item;
    protected Long appId;

    public ItemKeyDto() {
    }

    public ItemKeyDto(AppItemDto appItemDto, ItemDto itemDto, Long appId) {
        this.appItem = appItemDto;
        this.item = itemDto;
        this.appId = appId;
    }

    public ItemKeyDto(AppItemDto appItem, ItemDto item) {
        this.appItem = appItem;
        this.item = item;
    }

    public AppItemDto getAppItem() {
        return this.appItem;
    }

    public void setAppItem(AppItemDto appItem) {
        this.appItem = appItem;
    }

    public ItemDto getItem() {
        return this.item;
    }

    public void setItem(ItemDto item) {
        this.item = item;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getItemDtoType() {
        String appItemType = this.getAppItem() != null ? this.getAppItem().getType() : null;
        return this.getItem() != null ? this.getItem().getType() : appItemType;
    }

    public boolean isValid() {
        return this.getItem() != null || this.getAppItem() != null;
    }

    public boolean isItemMode() {
        return this.getItem() != null && this.getAppItem() == null;
    }

    public boolean isSelfAppItemMode() {
        return this.getItem() == null && this.getAppItem() != null;
    }

    public boolean isDuibaAppItemMode() {
        return this.getItem() != null && this.getAppItem() != null;
    }

    public Boolean isAmbItemKey() {
        boolean result = this.isSelfAppItemMode() ? this.getAppItem().isOpTypeAppItem(11) : this.getItem().isOpTypeItem(11);
        return this.isDuibaAppItemMode() ? Boolean.FALSE : result;
    }

    public boolean isAutoOff() {
        boolean itemAutoOff = false;
        Date today = new Date();
        if (this.getItem() != null && this.getItem().getAutoOffDate() != null) {
            itemAutoOff = this.getItem().getAutoOffDate().before(today);
        }
        boolean appItemAutoOff = false;
        if (this.getAppItem() != null && this.getAppItem().getAutoOffDate() != null) {
            appItemAutoOff = this.getAppItem().getAutoOffDate().before(today);
        }
        return itemAutoOff && appItemAutoOff;
    }

    public String getItemType() {
        if (this.getItem() != null) {
            return this.getItem().getType();
        }
        if (this.getAppItem() != null) {
            return this.getAppItem().getType();
        }
        return null;
    }

    public boolean isDevSecSkill() {
        if (this.appItem == null) {
            return false;
        }
        if (!this.appItem.isOpTypeAppItem(0)) {
            return false;
        }
        if ("phonebillDingzhi".equals(this.appItem.getType()) && this.appItem.getGmtModified().getTime() > 1537846200000L) {
            return true;
        }
        return this.appItem.getGmtCreate().getTime() > 1516244400000L;
    }

    public boolean isV1() {
        if (this.getAppItem() != null && this.getAppItem().getVersion() != null && this.getAppItem().getVersion().intValue() == 1) {
            return true;
        }
        return this.getItem() != null && this.getItem().getVersion() != null && this.getItem().getVersion().intValue() == 1;
    }

    public boolean isSecret() {
        if (!"virtual".equals(this.getItemDtoType())) {
            return false;
        }
        return false;
    }
}

