package cn.com.duiba.goods.center.api.remoteservice.dto.sku;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: AppItemSkuDto
 * @Description: 商品sku
 * @author: fxr
 * @date: 2018/6/11 下午4:19
 * @version: V1.0.0
 */
public class AppItemSkuDto implements Serializable {
    private static final long serialVersionUID = -6947827991146350424L;
    /**
     * 唯一ID
     */
    private Long id;

    /**
     * 商品ID
     */
    private Long appItemId;

    /**
     * 积分
     */
    private Long credits;

    /**
     * 展示价格
     */
    private Long facePrice;

    /**
     * 兑换价格
     */
    private Long salePrice;

    /**
     * 库存ID
     */
    private Long stockId;

    /**
     * 属性json串，多属性之间用';'分隔，属性值与key之间用‘：‘分隔，比如 属性ID:系统属性值:开发者自定义属性
     */
    private String attributeJson;

    /**
     * sku子图(预留)
     */
    private String imgUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 兑吧商品id
     */
    private Long itemId;

    /**
     * 兑吧商品sku id, app item关联item有用
     */
    private Long itemSkuId;

    /**
     * 商家编码
     */
    private String merchantCoding;

    /**
     * 是否可售 0：否  1：是
     */
    private Boolean saleStatus;


    /** ******扩展字段****** */
    /**
     * 库存
     */
    private Integer remaining;

    /**
     * 上一次库存
     */
    private Integer preRemaining;

    /** ******优惠券扩展字段（当前正在使用批次的信息）****** */
    /** 当前批次库存. */
    private Long currentStock;

    /** 当前批次初始库存. */
    private Long currentTotalStock;
    /**
     * 总库存
     */
    private Integer totalStock;
    /**
     * 有效期开始
     */
    private Date startDay;

    /**
     * 有效期结束
     */
    private Date endDay;

    /**
     * 供货价
     */
    private Long supplyPrice;

    /**
     * 卡券库id
     */
    private Long cardLibraryId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Long getFacePrice() {
        return facePrice;
    }

    public void setFacePrice(Long facePrice) {
        this.facePrice = facePrice;
    }

    public Long getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(Long salePrice) {
        this.salePrice = salePrice;
    }

    public Long getStockId() {
        return stockId;
    }

    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    public String getAttributeJson() {
        return attributeJson;
    }

    public void setAttributeJson(String attributeJson) {
        this.attributeJson = attributeJson;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemSkuId() {
        return itemSkuId;
    }

    public void setItemSkuId(Long itemSkuId) {
        this.itemSkuId = itemSkuId;
    }

    public String getMerchantCoding() {
        return merchantCoding;
    }

    public void setMerchantCoding(String merchantCoding) {
        this.merchantCoding = merchantCoding;
    }

    public Boolean getSaleStatus() {
        return saleStatus;
    }

    public void setSaleStatus(Boolean saleStatus) {
        this.saleStatus = saleStatus;
    }

    public Integer getRemaining() {
        return remaining;
    }

    public void setRemaining(Integer remaining) {
        this.remaining = remaining;
    }

    public Integer getPreRemaining() {
        return preRemaining;
    }

    public void setPreRemaining(Integer preRemaining) {
        this.preRemaining = preRemaining;
    }

    public Integer getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Integer totalStock) {
        this.totalStock = totalStock;
    }

    public Date getStartDay() {
        return startDay;
    }

    public void setStartDay(Date startDay) {
        this.startDay = startDay;
    }

    public Date getEndDay() {
        return endDay;
    }

    public void setEndDay(Date endDay) {
        this.endDay = endDay;
    }

    public Long getSupplyPrice() {
        return supplyPrice;
    }

    public void setSupplyPrice(Long supplyPrice) {
        this.supplyPrice = supplyPrice;
    }

    public Long getCardLibraryId() {
        return cardLibraryId;
    }

    public void setCardLibraryId(Long cardLibraryId) {
        this.cardLibraryId = cardLibraryId;
    }

    public Long getCurrentStock() {
        return currentStock;
    }

    public void setCurrentStock(Long currentStock) {
        this.currentStock = currentStock;
    }

    public Long getCurrentTotalStock() {
        return currentTotalStock;
    }

    public void setCurrentTotalStock(Long currentTotalStock) {
        this.currentTotalStock = currentTotalStock;
    }
}
