package cn.com.duiba.goods.center.api.remoteservice.dto.sku;

import java.io.Serializable;
import java.util.List;

/**
 * @Desc SKU规格属性链，树形结构
 * @Author xuwei
 * @Date 2018/11/6
 */
public class SkuAttributeNode<T extends Serializable> implements Serializable {
    private static final long serialVersionUID = 4889249887035984312L;

    //属性id
    private String id;
    //图片地址，目前只有根节点有
    private String imgUrl;
    //规格id, 实际是spec id
    private String specId;
    //销售信息（T可能为SKU信息、SKU积分换购信息）
    private T skuInfo;

    //子属性列表
    private List<SkuAttributeNode<T>> children;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getSpecId() {
        return specId;
    }

    public void setSpecId(String specId) {
        this.specId = specId;
    }

    public T getSkuInfo() {
        return skuInfo;
    }

    public void setSkuInfo(T skuInfo) {
        this.skuInfo = skuInfo;
    }

    public List<SkuAttributeNode<T>> getChildren() {
        return children;
    }

    public void setChildren(List<SkuAttributeNode<T>> children) {
        this.children = children;
    }

    /**
     * 销售信息
     */
    public static class SkuInfo implements Serializable {

        private static final long serialVersionUID = -9491789203686703L;
        /**
         * skuId，更新时使用
         */
        private String id;
        /**
         * 展示价格
         */
        private String facePrice;

        /**
         * 兑换价格
         */
        private String salePrice;

        /**
         * 商家编码
         */
        private String merchantCoding;

        /**
         * 图片链接（暂时取的是第一个规格属性配置的imgUrl）
         */
        private String imgUrl;

        /**
         * 库存id
         */
        private String stockId;

        /**
         * 剩余库存
         */
        private Integer remaining;

        /**
         * 前一次库存
         */
        private Integer preRemaining;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getFacePrice() {
            return facePrice;
        }

        public void setFacePrice(String facePrice) {
            this.facePrice = facePrice;
        }

        public String getSalePrice() {
            return salePrice;
        }

        public void setSalePrice(String salePrice) {
            this.salePrice = salePrice;
        }

        public String getMerchantCoding() {
            return merchantCoding;
        }

        public void setMerchantCoding(String merchantCoding) {
            this.merchantCoding = merchantCoding;
        }

        public String getImgUrl() {
            return imgUrl;
        }

        public void setImgUrl(String imgUrl) {
            this.imgUrl = imgUrl;
        }

        public String getStockId() {
            return stockId;
        }

        public void setStockId(String stockId) {
            this.stockId = stockId;
        }

        public Integer getRemaining() {
            return remaining;
        }

        public void setRemaining(Integer remaining) {
            this.remaining = remaining;
        }

        public Integer getPreRemaining() {
            return preRemaining;
        }

        public void setPreRemaining(Integer preRemaining) {
            this.preRemaining = preRemaining;
        }
    }

    /**
     * 管理后台销售信息
     */
    public static class SkuSupplyInfo extends SkuInfo{
        private static final long serialVersionUID = 5496247665871114160L;

        /**
         * 建议市场价(仅供管理后台用)
         */
        private String suggestMarketPrice;

        //卡券库id
        private String cardLibraryId;

        public String getSuggestMarketPrice() {
            return suggestMarketPrice;
        }

        public void setSuggestMarketPrice(String suggestMarketPrice) {
            this.suggestMarketPrice = suggestMarketPrice;
        }

        public String getCardLibraryId() {
            return cardLibraryId;
        }

        public void setCardLibraryId(String cardLibraryId) {
            this.cardLibraryId = cardLibraryId;
        }
    }

    /**
     * 开发者管理后台销售信息
     */
    public static class AppItemSkuInfo extends SkuInfo {
        private static final long serialVersionUID = 3929321445588475360L;
        //供货价
        private String supplyPrice;
        //兑吧商品skuId
        private String itemSkuId;
        //卡券库id
        private String cardLibraryId;

        public String getItemSkuId() {
            return itemSkuId;
        }

        public void setItemSkuId(String itemSkuId) {
            this.itemSkuId = itemSkuId;
        }

        public String getCardLibraryId() {
            return cardLibraryId;
        }

        public void setCardLibraryId(String cardLibraryId) {
            this.cardLibraryId = cardLibraryId;
        }

        public String getSupplyPrice() {
            return supplyPrice;
        }

        public void setSupplyPrice(String supplyPrice) {
            this.supplyPrice = supplyPrice;
        }
    }
}
