package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemExtraDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 商品附加信息服务
 * Created by xiaoxuda on 2016/12/6.
 */
@AdvancedFeignClient
public interface RemoteGoodsAppItemExtraService {
    /**
     * 通过appItemId查询对应商品附加信息
     *
     * @param appItemId 非空
     * @return
     */
    DubboResult<AppItemExtraDto> findByAppItemId(Long appItemId);

    /**
     * 插入商品附加信息，appItemId不能为空
     *
     * @param appItemExtra
     * @return
     */
    DubboResult<Integer> insert(AppItemExtraDto appItemExtra);

    /**
     * 通过appItemId更新对应商品附加信息，appItemId 非空
     *
     * @param appItemExtra
     * @return
     */
    DubboResult<Integer> updateByAppItemId(AppItemExtraDto appItemExtra);

    /**
     * 通过appItemId删除对应商品附加信息
     *
     * @param appItemId 非空
     * @return
     */
    DubboResult<Integer> deleteByAppItemId(Long appItemId);

    /**
     * 插入或通过appItemId更新对应商品附加信息，appItemId 非空
     *
     * @param appItemExtra
     * @return
     */
    DubboResult<Integer> insertOrUpdateByAppItemId(AppItemExtraDto appItemExtra);
}
