package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @Desc 开发者商品分页查询参数
 * @Author xuwei
 * @Date 2018/12/17
 */
public class AppItemPageQueries implements Serializable {
    private Long appId;
    private String type;
    private Integer subType;
    private Long classifyId;
    private Boolean originalPriceBuy;
    private Boolean isOwner;
    private String status;
    private String title;
    private List<Long> ids;
    private int pageSize;
    private int pageNo;
    private int offset = -1;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = StringUtils.isBlank(type) ? null : type;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Boolean getOriginalPriceBuy() {
        return originalPriceBuy;
    }

    public void setOriginalPriceBuy(Boolean originalPriceBuy) {
        this.originalPriceBuy = originalPriceBuy;
    }

    public Boolean getIsOwner() {
        return isOwner;
    }

    public void setIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = StringUtils.isBlank(status) ? null : status;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = StringUtils.isBlank(title) ? null : title;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public List<Long> getIds() {
        return CollectionUtils.isEmpty(ids) ? null : ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = CollectionUtils.isEmpty(ids) ? null : ids;
    }

    public int getOffset() {
        if (offset == -1) {
            offset = pageSize * (pageNo - 1);
        }
        return offset;
    }
}
