/**
 * Project Name:goods-center-api
 * File Name:CouponType.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.enums
 * Date:2016年5月23日下午12:27:56
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ClassName:CouponType <br/>
 * Function: 优惠劵的类型 <br/>
 * Date:     2016年5月23日 下午12:27:56 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public enum CouponType {
    Normal(0, "普通券码"), Link(1, "跳转连接"), Repeat(2, "可重复使用券码"), CryptoCard(3, "卡密");
    private final int value;
    private final String desc;

    private CouponType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    
    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static List<CouponType> getCouponTypeList() {
        List<CouponType> enumList = Lists.newArrayList();
        CouponType[] tempEnums = CouponType.values();
        for (CouponType tempEnum : tempEnums) {
            if (tempEnum.getValue() != CryptoCard.getValue()) {
                enumList.add(tempEnum);
            }
        }
        return enumList;
    }

    public static CouponType of(int value) {
        for (CouponType type : values()) {
            if (type.getValue() == value) {
                return type;
            }
        }
        return null;
    }

    @JsonValue
    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashMap<>();
        map.put("value", value);
        map.put("desc", desc);
        return map;
    }
}

