package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * 积分兑换积分转换方式
 * Created by sunyan on 2018/11/12.
 */
public enum ExchangeTypeEnum {
    AUTOMATIC(1, "自动"),
    CUSTOM(2, "自定义");

    private Integer code;
    private String desc;

    ExchangeTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ExchangeTypeEnum getByCode(int code) {
        for (ExchangeTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
