package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * Created by xiaoxuda on 2018/7/31.
 */
public enum GoodsItemSourceType {
    SAAS(1, "Saas商品"),
    DUIBA_ITEM(2, "兑吧商品"),
    APP_ITEM(3, "开发者商品");

    private Integer code;
    private String desc;

    GoodsItemSourceType(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static GoodsItemSourceType getByCode(int code){
        for(GoodsItemSourceType type : values()){
            if(type.getCode().equals(code)){
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
