package cn.com.duiba.goods.center.api.remoteservice.enums;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemBaseDto;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by xutao on 2018/11/22.
 */
public enum SaasMallVTypeEnum {
    /**
     * 积分商城类型
     */
    UNKNOW(-1, "未知", null),
    NOR_MALL(1, "标准版", ItemBaseDto.OpTypeLimitVNormal),
    PRO_MALL(2, "专业版", ItemBaseDto.OpTypeLimitVPro),
    FLAG_MALL(3, "旗舰版", ItemBaseDto.OpTypelimitVFlag),
    EXTRAME_MALL(4, "至尊版", ItemBaseDto.OpTypeUltimate),
    VIP_MALL(99, "兑吧VIP",null),
    ;

    private int code;

    private String desc;
    //位移开关控制
    private Integer bit;

    SaasMallVTypeEnum(int code, String desc, Integer bit) {
        this.code = code;
        this.desc = desc;
        this.bit = bit;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public int getBit() {
        return bit;
    }

    public static SaasMallVTypeEnum getSaasMallVTypeEnumByCode(int code) {
        SaasMallVTypeEnum[] tempEnums = SaasMallVTypeEnum.values();
        for (SaasMallVTypeEnum tempEnum : tempEnums) {
            if (code == tempEnum.getCode()) {
                return tempEnum;
            }
        }
        return SaasMallVTypeEnum.UNKNOW;
    }

    public static List<SaasMallVTypeEnum> getSaasMallVTypeList() {
        List<SaasMallVTypeEnum> enumList = Lists.newArrayList();
        SaasMallVTypeEnum[] tempEnums = SaasMallVTypeEnum.values();
        for (SaasMallVTypeEnum tempEnum : tempEnums) {
            if (tempEnum.getCode() != UNKNOW.getCode() && tempEnum.getCode() != VIP_MALL.getCode()) {
                enumList.add(tempEnum);
            }
        }
        return enumList;
    }

    @JsonValue
    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashMap<>();
        map.put("code", code);
        map.put("desc", desc);
        return map;
    }
}
