package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemLimitConfigDto;

import java.util.List;
import java.util.Map;

/**
 * @Desc 商品限购service
 * @Author xuwei
 * @Date 2018/11/6
 */
@AdvancedFeignClient
public interface RemoteItemLimitConfigService {
    /**
     * 根据自有商品id查询
     *
     * @param appItemId
     * @return
     */
    ItemLimitConfigDto findByAppItemId(Long appItemId);

    /**
     * 根据兑吧商品id查询
     *i
     * @param itemId
     * @return
     */
    ItemLimitConfigDto findByItemId(Long itemId);

    /**
     * 根据兑吧商品id列表查询
     *i
     * @param itemIdList
     * @return
     */
    Map<Long, ItemLimitConfigDto> findByItemIdList(List<Long> itemIdList) throws BizException;

    /**
     * 插入
     *
     * @param itemLimitConfig
     * @return
     */
    Long insert(ItemLimitConfigDto itemLimitConfig) throws BizException;

    /**
     * 更新
     *
     * @param itemLimitConfig
     * @return
     */
    Integer update(ItemLimitConfigDto itemLimitConfig) throws BizException;
}
