package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by xutao on 2018/11/5.
 */
public class ItemDescConfigDto implements Serializable {

    private static final long serialVersionUID = -5031061334272269722L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 自有商品id
     */
    private Long appItemId;

    /**
     * 供应商商品id
     */
    private Long itemId;

    /**
     * 详情
     */
    private String description;

    /**
     * 商品详情图
     */
    private String multiImage;

    /**
     * 待发货文案
     */
    private String alertMessage;

    /**
     * 卖点描述
     */
    private String sellingPoint;

    /**
     * 微信分享描述
     */
    private String weixinShareDesc;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMultiImage() {
        return multiImage;
    }

    public void setMultiImage(String multiImage) {
        this.multiImage = multiImage;
    }

    public String getAlertMessage() {
        return alertMessage;
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage;
    }

    public String getSellingPoint() {
        return sellingPoint;
    }

    public void setSellingPoint(String sellingPoint) {
        this.sellingPoint = sellingPoint;
    }

    public String getWeixinShareDesc() {
        return weixinShareDesc;
    }

    public void setWeixinShareDesc(String weixinShareDesc) {
        this.weixinShareDesc = weixinShareDesc;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public static ItemDescConfigDto convertOldItemDto(ItemDto dto) {
        if (dto == null) {
            return null;
        }

        ItemDescConfigDto itemDescConfigDto = new ItemDescConfigDto();
        itemDescConfigDto.setItemId(dto.getId());
        itemDescConfigDto.setDescription(dto.getDescription());
        itemDescConfigDto.setMultiImage(dto.getMultiImage());
        itemDescConfigDto.setAlertMessage(dto.getAlertMessage());
        return itemDescConfigDto;
    }
}
