package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;

/**
 * @Desc 商品查询参数
 * @Author xuwei
 * @Date 2018/11/23
 */
public class ItemQueries implements Serializable {

    private static final int OFFSET_DESC = 1;
    private static final int OFFSET_LIMIT = 1 << 1;
    private static final int OFFSET_SKU = 1 << 2;
    private static final int OFFSET_CREDITS = 1 << 3;
    private static final int OFFSET_CREDITS_SKU = 1 << 4;

    private int value;

    public ItemQueries() {

    }

    private ItemQueries(boolean all) {
        if (all) {
            value = Integer.MAX_VALUE;
        }
    }

    public static ItemQueries empty() {
        return new ItemQueries();
    }

    public static ItemQueries all() {
        return new ItemQueries(true);
    }

    public ItemQueries withDescConfig() {
        return with(OFFSET_DESC);
    }

    public ItemQueries withLimitConfig() {
        return with(OFFSET_LIMIT);
    }

    public ItemQueries withSku() {
        return with(OFFSET_SKU);
    }

    public ItemQueries withCredits() {
        return with(OFFSET_CREDITS);
    }

    public ItemQueries withCreditsSku() {
        return with(OFFSET_CREDITS_SKU);
    }

    private ItemQueries with(int offset) {
        value |= offset;
        return this;
    }

    public ItemQueries withoutDescConfig() {
        return without(OFFSET_DESC);
    }

    public ItemQueries withoutLimitConfig() {
        return without(OFFSET_LIMIT);
    }

    public ItemQueries withoutSku() {
        return without(OFFSET_SKU);
    }

    public ItemQueries withoutCredits() {
        return without(OFFSET_CREDITS);
    }

    public ItemQueries withoutCreditsSku() {
        return without(OFFSET_CREDITS_SKU);
    }

    private ItemQueries without(int offset) {
        value &= ~offset;
        return this;
    }

    public boolean hasDescConfig() {
        return has(OFFSET_DESC);
    }

    public boolean hasLimitConfig() {
        return has(OFFSET_LIMIT);
    }

    public boolean hasSku() {
        return has(OFFSET_SKU);
    }

    public boolean hasCredits() {
        return has(OFFSET_CREDITS);
    }

    public boolean hasCreditsSku() {
        return has(OFFSET_CREDITS_SKU);
    }

    private boolean has(int offset) {
        return (value & offset) > 0;
    }
}
