package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;

/**
 * @Desc 卡券库管理service
 * @Author xuwei
 * @Date 2018/11/27
 */
@AdvancedFeignClient
public interface RemoteCardLibraryBackendService {
    /**
     * 无缓存查询
     *
     * @param id
     * @return
     */
    CardLibraryDto find(Long id);

    /**
     * 保存
     *
     * @param record
     * @return
     * @throws BizException
     */
    Long save(CardLibraryDto record) throws BizException;

    /**
     * 更新
     *
     * @param record
     * @return
     * @throws BizException
     */
    int update(CardLibraryDto record) throws BizException;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws BizException
     */
    int delete(Long id) throws BizException;

    /**
     * 分页
     *
     * @param appId
     * @param type
     * @param name
     * @param pageNo
     * @param pageSize
     * @return
     * @throws BizException
     */
    Page<CardLibraryDto> page(Long appId, Integer type, String name, int pageNo, int pageSize) throws BizException;
}
