package cn.com.duiba.goods.center.api.remoteservice.sku;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.ItemSkuDto;

import java.util.List;


@AdvancedFeignClient
public interface RemoteItemSkuService {
    /**
     * 根据兑吧商品id，查询sku信息
     */
    List<ItemSkuDto> findSkuListByItemId(Long itemId);

    /**
     * 根据兑吧商品id列表，查询sku信息
     */
    List<ItemSkuDto> findSkuByItemIdList(List<Long> itemIds);

    Integer batchSaveSku(List<ItemSkuDto> itemSkuDtoList);

    Integer deleteSkuByItemId(Long itemId);

    /**
     * 批量更新统一商品下的sku
     *
     * @param itemId
     * @param itemSkuDtoList
     * @return
     * @throws BizException
     */
    Integer batchUpdateSkuByItemId(Long itemId, List<ItemSkuDto> itemSkuDtoList) throws BizException;

    /**
     * 查询sku
     * @param skuId
     * @return
     */
    ItemSkuDto findSkuById(Long skuId);
}
