/**
 * Project Name:goods-center-api File Name:RemoteAdvertCouponGoodsBackendService.java Package
 * Name:cn.com.duiba.goods.center.api.remoteservice Date:2016年7月13日下午8:13:34 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.AdvertCouponGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.ChangeACGTypeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemoteAdvertCouponGoodsBackendService <br/>
 * Function: 广告优惠卷商品Service. <br/>
 * Date: 2016年7月13日 下午8:13:34 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@AdvancedFeignClient
public interface RemoteAdvertCouponGoodsBackendService {

    /**
     * 创建广告卷商品.
     *
     * @param goods the goods
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> createAdvertCouponGoods(AdvertCouponGoodsDto goods);

    /**
     * 修改广告卷商品.
     *
     * @param acgId 优惠卷ID
     * @param goods the goods
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> editAdvertCouponGoods(Long acgId, AdvertCouponGoodsDto goods);

    /**
     * 删除广告卷(逻辑删除).
     *
     * @param acgId 优惠卷ID
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> deleteGoods(Long acgId);

    /**
     * 查询广告卷信息.
     *
     * @param acgId 优惠卷ID
     * @return the dubbo result< advert coupon goods dto>
     */
    DubboResult<AdvertCouponGoodsDto> find(Long acgId);

    /**
     * 切换优惠券类型
     * @param t 类型
     * @return
     */
    DubboResult<Boolean> changeACGType(ChangeACGTypeDto t);
    /**
     * 优根据广告优惠券名称返回广告券ids.
     *
     * @param couponName 优惠券名称
     * @return the dubbo result< advert coupon goods dto>
     */
    DubboResult<List<Long>> findByNameGoodIds(String couponName);

    /**
     * 注意acgIdList的长度最多只允许（一次查询）300个，超过直接抛出异常，因此若超过长度调用方需分批次查询
     * 批量查询广告券推广地址
     * @param acgIdList 优惠券ID列表
     * @return
     */
    DubboResult<List<AdvertCouponGoodsDto>> findByAcgIds(List<Long> acgIdList);
}
