package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.TbGoodsOpenUrlDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 马上使用按钮获后台服务
 */
@AdvancedFeignClient
public interface RemoteImmediatelyButtonBackendService {

	/**
	 * createItem:添加优惠券或者更新优惠券. <br/>
	 *
	 * @author guoeryang
	 * @param itemId
	 * @param androidDownload
	 * @param iosDownload
	 * @param immediatelyButton
	 * @param gtype
	 * @param switches
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<Void> updateTbGoodsOpenurl(Long itemId, String androidDownload, String iosDownload, Integer immediatelyButton, GoodsTypeEnum gtype, Long switches);

	/**
	 * createItem:查询马上使用按钮 信息. <br/>
	 *
	 * @author guoeryang
	 * @param itemId
	 * @param gtype
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<TbGoodsOpenUrlDto> selectTbGoodsOpenurlByid(Long itemId, GoodsTypeEnum gtype);

}
