/**
 * Project Name:goods-center-api
 * File Name:RemotePlatformCouponGoodsBackendService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年5月19日下午3:58:05
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGInsertDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemotePlatformCouponGoodsBackendService <br/>
 * Function: 平台券商品后台服务. <br/>
 * Date:     2016年5月19日 下午3:58:05 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemotePlatformCouponGoodsBackendService {
    
    
    /**
     * 获取首页2张图片
     *
     * @author xuhengfei
     * @return 长度为2的列表，第一个是logo图，第二个是Banner图
     * @since JDK 1.6
     */
    public DubboResult<List<String>> getHomeImages();
    /**
     * 编辑首页2张图片
     *
     * @author xuhengfei
     * @param logoImage Logo图
     * @param bannerImage Banner图
     * @return 是否成功
     * @since JDK 1.6
     */
    public DubboResult<Boolean> editHomeImages(String logoImage,String bannerImage);
    /**
     * 创建一个平台券商品
     *
     * @author xuhengfei
     * @param goods 商品信息
     * @return 商品id
     * @since JDK 1.6
     */
    public DubboResult<Long> createPlatformCouponGoods(PCGInsertDto goods);
    /**
     * 编辑商品 <br/>
     *  如果属性为null，则不对该属性进行更新操作
     *
     * @author xuhengfei
     * @param pcgId 商品id
     * @param goods 商品信息对象
     * @return 是否成功
     * @since JDK 1.6
     */
    public DubboResult<Boolean> editPlatformCouponGoods(Long pcgId,PCGEditDto goods);
     /**
      * 上架商品
      *
      * @author xuhengfei
      * @param pcgId 商品id
      * @return 是否成功
      * @since JDK 1.6
      */
    public DubboResult<Boolean> onshelfGoods(Long pcgId);
     /**
      * 下架商品
      * offshelfGoods:(这里用一句话描述这个方法的作用). <br/>
      * @author xuhengfei
      * @param pcgId 商品id
      * @return 是否成功
      * @since JDK 1.6
      */
    public DubboResult<Boolean> offshelfGoods(Long pcgId);
     /**
      * 删除商品
      *
      * @author xuhengfei
      * @param pcgId 商品id
      * @return 是否成功
      * @since JDK 1.6
      */
    public DubboResult<Boolean> deleteGoods(Long pcgId);
    /**
     * 查找商品
     *
     * @author xuhengfei
     * @param pcgId 商品id
     * @return 商品信息
     * @since JDK 1.6
     */
    public DubboResult<PCGDto> find(long pcgId);
    /**
     * 根据名称搜索商品
     *
     * @author xuhengfei
     * @param name 名称
     * @return 结果集
     * @since JDK 1.6
     */
    public DubboResult<List<PCGDto>> searchByName(String name);
    /**
     * 分页查询商品列表
     *
     * @author xuhengfei
     * @param name 名称
     * @param pcgStatus 平台券状态
     * @param pageSize 分页大小
     * @param pageIndex 页码
     * @return
     * @since JDK 1.6
     */
    public Page<PCGDto> findPage(String name,Integer pcgStatus,int pageSize,int pageIndex);
    

    /**
     * 
     * editSwitches:位运算. <br/>
     * @author wubo
     * @param pcgId 平台券id
     * @param bit 第几位
     * @param open 开(true)/关(false)
     * @return 是否成功
     * @since JDK 1.6
     */
    public DubboResult<Boolean> editSwitches(Long pcgId,Integer bit,Boolean open);
    
}

