package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;
import java.util.Date;

/**
 * itemKey Dto
 */
public class ItemKeyDto implements Serializable {

	private static final long serialVersionUID = 284762871342171085L;

	protected AppItemDto appItem;

	protected ItemDto item;

	protected Long appId;

	public ItemKeyDto() {

	}

	/**
	 * ItemKeyDto
	 * @param appItemDto
	 * @param itemDto
	 * @param appId
	 */
	public ItemKeyDto(AppItemDto appItemDto, ItemDto itemDto, Long appId) {
		this.appItem = appItemDto;
		this.item = itemDto;
		this.appId = appId;
	}

	/**
	 * ItemKeyDto
	 * @param appItem
	 * @param item
	 */
	public ItemKeyDto(AppItemDto appItem, ItemDto item) {
		this.appItem = appItem;
		this.item = item;
	}

	public AppItemDto getAppItem() {
		return appItem;
	}

	public void setAppItem(AppItemDto appItem) {
		this.appItem = appItem;
	}

	public ItemDto getItem() {
		return item;
	}

	public void setItem(ItemDto item) {
		this.item = item;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	/**
	 * getItemDtoType
	 * @return
	 */
	public String getItemDtoType() {
		String appItemType = this.getAppItem() != null ? this.getAppItem().getType() : null;
		return this.getItem() != null ? this.getItem().getType() : appItemType;
	}

	/**
	 * isValid
	 * @return
	 */
	public boolean isValid() {
		return this.getItem() != null || this.getAppItem() != null;
	}

	/**
	 * isItemMode
	 * @return
	 */
	public boolean isItemMode() {
		return this.getItem() != null && this.getAppItem() == null;
	}

	/**
	 * isSelfAppItemMode
	 * @return
	 */
	public boolean isSelfAppItemMode() {
		return this.getItem() == null && this.getAppItem() != null;
	}

	/**
	 * isDuibaAppItemMode
	 * @return
	 */
	public boolean isDuibaAppItemMode() {
		return this.getItem() != null && this.getAppItem() != null;
	}

	/**
	 * isAmbItemKey
	 * @return
	 */
	public Boolean isAmbItemKey() {
		boolean result = this.isSelfAppItemMode() ? this.getAppItem().isOpTypeAppItem(ItemDto.OpTypeIsAmb) : this.getItem().isOpTypeItem(ItemDto.OpTypeIsAmb);
		return this.isDuibaAppItemMode() ? Boolean.FALSE : result;
	}

	/**
	 * isAutoOff
	 * @return
	 */
	public boolean isAutoOff() {
		boolean itemAutoOff = false;
		Date today = new Date();
		if (this.getItem() != null && this.getItem().getAutoOffDate() != null) {
			itemAutoOff = this.getItem().getAutoOffDate().before(today);
		}

		boolean appItemAutoOff = false;
		if (this.getAppItem() != null && this.getAppItem().getAutoOffDate() != null) {
			appItemAutoOff = this.getAppItem().getAutoOffDate().before(today);
		}

		return itemAutoOff && appItemAutoOff;
	}

	public String getItemType() {
		if (getItem() != null) {
			return getItem().getType();
		}
		if (getAppItem() != null) {
			return getAppItem().getType();
		}
		return null;
	}

	/**
	 * 判断是否是开发者秒杀商品
	 * @return
     */
	public boolean isDevSecSkill(){
		if(this.appItem==null){
			return false;
		}
		if(!this.appItem.isOpTypeAppItem(ItemDto.OpTypeTimeLimit)){
			return false;
		}
		return this.appItem.getGmtCreate().getTime()>1516244400000L;//2018-01-18 11:00:00
	}
}
