package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.biz.tool.duiba.dto.KeyValueDto;
import cn.com.duiba.biz.tool.duiba.entity.KeyValueEntity;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemNewExtraDto;

import java.util.List;

/**
 *
 * 商品新拓展信息接口
 * 增加app item的接口请加appItem
 * Created by hww on 2018/4/25 下午8:20.
 */
@AdvancedFeignClient
public interface RemoteItemNewExtraService {

    /**
     * 单独find item extra,注意不是app item extra
     * @param itemId
     * @return
     */
    ItemNewExtraDto findItemNewExtra(Long itemId);

    /**
     * 批量insert Item extra
     * @param itemId
     * @return
     */
    int updateOrInsertBatch(Long itemId, List<KeyValueDto> kvs);

    int updateOrInsertAppItemExtra(Long appItemId, KeyValueDto kvs);

    /**
     * 单独insert Item extra
     * @param itemId
     * @return
     */
    int updateOrInsertOne(Long itemId, String propName, String propValue);

    /**
     * 单独删除Item extra
     * @param itemId
     * @return
     */
    int deleteOneValue(Long itemId, String propName);

    /**
     * 删除Item extra
     * @param itemId
     * @return
     */
    boolean deleteByItemId(Long itemId);

    /**
     * 批量insert appItem请使用insertAppItemBatch
     * @param appItemId
     * @param kvs
     * @return
     */
    @Deprecated
    int insertBatch(Long appItemId, List<KeyValueDto> kvs);

    /**
     * 批量insert appItem
     * @param appItemId
     * @param kvs
     * @return
     */
    int insertAppItemBatch(Long appItemId, List<KeyValueDto> kvs);

    /**
     * 单独insert appItem
     * @param appItemId
     * @param kvs
     * @return
     */
    int updateAppItem(Long appItemId, KeyValueDto kvs);

    List<KeyValueEntity> findAppItemNewExtra(Long appItemId,Long limitNum);

    List<KeyValueEntity> findAppItemAll(Long appItemId);

    int updateEntries(Long appItemId,List<KeyValueDto> kv);

    List<KeyValueEntity> findAppItemEntriesByItemAndProp(List<Long> appItemIdList, String propName, String propValue);
}
