package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.BaseImgDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.ItemExtraDtoEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * item 扩展表
 */
public class ItemExtraDto extends BaseImgDto implements Serializable {
    private static final long serialVersionUID = -26122562121559924L;

    private Long   id;
    private Long   itemId;
    //商品备注
    private String name4Admin;
    private Date   gmtCreate;
    private Date   gmtModified;
    private String usePrompt;
    private String btnText;
    private String ownerAppIds;
    private Long supplierId;
    private String shareImage;
    /**
     * 商品状态
     * 针对供应商系统同步的商品
     * 使用二进制状态位
     * 第一位表示 商品修改的状态 0  1
     */
    private Long operationType;

    /**
     * 随机奖金区间,用于集卡商品
     * 保存格式 a,b
     * 0 < a <= b
     * a,b是以人民币分为单位的整数
     * */
    private String bonusArea;

    /**
     * 供应商名称
     */
    private String supplierName;


    /** 额外商品定制
     * @see cn.com.duiba.goods.center.api.remoteservice.enums.ItemExtraDtoEnum;
     */
    private  Integer customGoods ;

    public Integer getCustomGoods() {
        return customGoods;
    }

    public void setCustomGoods(Integer customGoods) {
        this.customGoods = customGoods;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    /**供应商商品状态 0同步  1 编辑完成 */
    public static final int OpTypeSupplierStatus=0;

    /**
     *  直接在DTO中进行开关的切换比较危险,请直接使用SwitchUtils
     * @param opType
     */
    public void grantOpTypeItem(int opType) {
        int v = 1 << opType;
        this.operationType = this.operationType | v;
    }

    /**
     * ungrantOpTypeItem
     * @param opType
     */
    public void ungrantOpTypeItem(int opType) {
        int v = 1 << opType;
        v = ~v;
        this.operationType = this.operationType & v;
    }

    public String getShareImage() {
        return shareImage;
    }

    public void setShareImage(String shareImage) {
        this.shareImage = shareImage;
    }

    public String getOwnerAppIds() {
        return ownerAppIds;
    }

    public void setOwnerAppIds(String ownerAppIds) {
        this.ownerAppIds = ownerAppIds;
    }

    public String getUsePrompt() {
        return usePrompt;
    }

    public void setUsePrompt(String usePrompt) {
        this.usePrompt = usePrompt;
    }

    public String getBtnText() {
        return btnText;
    }

    public void setBtnText(String btnText) {
        this.btnText = btnText;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getName4Admin() {
        return name4Admin;
    }

    public void setName4Admin(String name4Admin) {
        this.name4Admin = name4Admin;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getBonusArea() {
        return bonusArea;
    }

    public void setBonusArea(String bonusArea) {
        this.bonusArea = bonusArea;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Long getOperationType() {
        return operationType;
    }

    public void setOperationType(Long operationType) {
        this.operationType = operationType;
    }
}
