package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;

import java.util.Date;
import java.util.List;

/**
 * @Desc 卡券库管理service
 * @Author xuwei
 * @Date 2018/11/27
 */
@AdvancedFeignClient
public interface RemoteCardLibraryBackendService {
    /**
     * 无缓存查询
     *
     * @param id
     * @return
     */
    CardLibraryDto find(Long id);

    /**
     * 保存
     *
     * @param record
     * @return
     * @throws BizException
     */
    Long save(CardLibraryDto record) throws BizException;

    /**
     * 更新
     *
     * @param record
     * @return
     * @throws BizException
     */
    int update(CardLibraryDto record) throws BizException;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws BizException
     */
    int delete(Long id) throws BizException;

    /**
     * 分页
     *
     * @param appId
     * @param type
     * @param name
     * @param appItemId
     * @param itemId
     * @param forRelation 是否为了关联查询？
     * @param pageNo
     * @param pageSize
     * @return
     * @throws BizException
     */
    Page<CardLibraryDto> pageNew(Long appId, Integer type, String name, Long appItemId, Long itemId, boolean forRelation, Integer cardLibraryType, int pageNo, int pageSize) throws BizException;

    /**
     * 请用pageNew接口代替
     * @param appId
     * @param type
     * @param name
     * @param appItemId
     * @param itemId
     * @param forRelation
     * @param pageNo
     * @param pageSize
     * @return
     * @throws BizException
     */
    @Deprecated
    Page<CardLibraryDto> page(Long appId, Integer type, String name, Long appItemId, Long itemId, boolean forRelation, int pageNo, int pageSize) throws BizException;

    /**
     * 批量关联卡券库
     *
     * @param records
     * @param isApp 是否开发者商品
     * @return
     */
    int batchUpdateRelation(List<CardLibraryDto> records, boolean isApp) throws BizException;

    /**
     * 查询指定商品卡券库列表
     *
     * @param itemId
     * @param skuIds
     * @param isApp  是否开发者商品
     * @return
     */
    List<CardLibraryDto> findByItemIdAndSkuIds(Long itemId, List<Long> skuIds, boolean isApp);

    /**
     * 根据id列表查询
     *
     * @param ids
     * @return
     */
    List<CardLibraryDto> findByIds(List<Long> ids);

    /**
     * 更新过期时间
     *
     * @param id
     * @param expiredDate
     * @return
     */
    int updateExpiredDateById(Long id, Date expiredDate) throws BizException;

    /**
     * 根据商品id列表查询
     *
     * @param itemIds
     * @param isApp
     * @return
     */
    List<CardLibraryDto> findByItemIds(List<Long> itemIds, boolean isApp);

    /**
     * 按入库商品id，skui查询卡
     *
     * @param appItemId
     * @param skuId
     * @return
     */
    CardLibraryDto selectBySkuAndAppItemId(Long appItemId, Long skuId);

    /**
     * 按兑吧商品id，skui查询卡
     *
     * @param itemId
     * @param skuId
     * @return
     */
    CardLibraryDto selectBySkuAndItemId(Long itemId, Long skuId);

    /**
     * 按卡券库名称查询
     *
     * @param cardName
     * @return
     */
    List<CardLibraryDto> findByCardName(Long appId, String cardName, Integer type, Integer cardLibraryType);

    List<Long> selectId(List<Long> ids);
}
