package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.sku.ItemSkuDto;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 兑吧商品DTO
 */
public class ItemDto extends ItemBaseDto implements Serializable {

    private static final long serialVersionUID = -2680175256212159924L;

    //商品图文描述
    private ItemDescConfigDto itemDescConfigDto;

    //商品用户维度限购配置
    private ItemLimitConfigDto itemLimitConfigDto;

    //商品sku规格属性
    private List<ItemSkuDto> itemSkuDtoList;

    //商品价格区间
    private ItemPriceDto itemPriceDto;

	//是否为多规格
	private Boolean multiSku;
	//分销商id
	private Long distributorId;
	//商家编码 预留字段
	private String merchantCoding;

	//开关控制改造
	//是否活动专用
	private Boolean enableTypeActivity;
	//是否折扣商品
	private Boolean enableTypeDiscountGoods;
	//是否定向发放
	private Boolean enableTypeSpecify;
	//是否黑名单
	private Boolean enableTypeDevBlacklist;
	//是否预分配库存
	private Boolean enableTypePreStockSwith;


	/**
	 * ItemDescConfigDto 商品图文描述字段开始
	 */
	//详情
	private String  description;
	//现在smallImage会填充到whiteImage,后期只在Dto中保留一个
	private String  whiteImage;
	//商品详情图
	private String  multiImage;
	//待发货文案
	private String  alertMessage;
	//卖点描述，新增,去ItemDescConfigDto中取
//	private String sellingPoint;
//	//优惠券使用规则
//	private String usageRule;
	/**
	 * ItemDescConfigDto 商品图文描述字段结束
	 */



	/**
	 * ItemLimitConfigDto 商品用户维度限购配置
	 */
	//兑换限制数量
	private Integer limitCount;
	//用户兑换限制范围(每天,天或者永久)
	private String  limitScope;
	/**
	 * ItemLimitConfigDto 商品用户维度限购配置
	 */


	public ItemDto() {
    }

    public ItemDto(boolean init4insert) {
        if (init4insert) {
            facePrice = 0;
            marketPrice = 0;
            actualPrice = 0;
            minCredits = 0L;
            minFacePrice = 0;
            enable = false;
            remaining = 0;
            sales = 0;
            payload = 0;
            duibaType = 0;
            autoRecommend = false;
            deleted = false;
            sourceType = SourceTypeNormal;
            shutDown = false;
            operationsType = 0;
            limitScope = ItemDto.LimitTypeForever;
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    private Long    id;
    private String  tag;
    private String  name;
    private String  subtitle;
    private String  logo;
    private String  image;

	@Deprecated
	//最小兑换金额
    private Integer facePrice;
	//市场价，迁移到sku
    private Integer marketPrice;
	//供货价
    private Integer actualPrice;
	@Deprecated
    private Long    minCredits;
	@Deprecated
    private Integer minFacePrice;
	@Deprecated
	//兑换成功文案
	private String  exchangeTipTemplate;

	//缩略图
	private String  smallImage;

    private Boolean suggestDownload;
    private String  iosOpen;
    private String  iosDownload;
    private String  androidDownload;
    private Boolean enable;

    private Integer remaining;
    private Integer sales;
    private Integer payload;
    //多档位价格
    private String  customPrice;



    private String  type;
    private Integer typeInt;

    private Long    ownerAppId;
    private Long    batchId;
    private Long    itemClassifyId;
    private Date    validStartDate;
    private Date    validEndDate;
    private Date    publishTime;
    private Boolean deleted;
    //商品费率
    private String  productPrice;
    private Boolean shutDown;
    private Boolean showAlert;

    private Integer duibaType;
    private Boolean autoRecommend;
    private Integer subType;
    private String  bannerImage;
    private Date    gmtCreate;
    private Date    gmtModified;
    private Integer operationsType;
    private String  limitTimeBetween;
    private Integer limitEverydayQuantity;
    private String  limitDate;
    private Integer sourceType;
    private Long    sourceRelationId;
    private Date    autoOffDate;
    private String  name4Admin;
    private String  usePrompt;
    private String  btnText;
	@Deprecated
    private Long    salePrice;
    private String  expressType;
    //运费价格
    private Long    expressPrice;
    private Long    expressTemplateId;
    private Integer stockWarnValue;
    @Deprecated
    private Long    sellerId;
	@Deprecated
    private String  sellerName;
    private Long    adminId;
    private Integer immediatelyButton;
    //version号
    private Long version;

    //extra dto
    private ItemExtraDto itemExtraDto;
	//关联库存中心的stockId
    private Long stockId;

	/**
	 *  直接在DTO中进行开关的切换比较危险,请直接使用SwitchUtils
	 *
	 * @param opType
	 */
    public void grantOpTypeItem(int opType) {
        int v = 1 << opType;
        this.operationsType = this.operationsType | v;
    }
    
    /**
     * ungrantOpTypeItem
     * @param opType
     */
    public void ungrantOpTypeItem(int opType) {
        int v = 1 << opType;
        v = ~v;
        this.operationsType = this.operationsType & v;
    }

    /**
     * ungrantOpTypeItem
     * @param opType
     * @return
     */
    public boolean isOpTypeItem(int opType) {
        int v = 1 << opType;
        int ret = this.operationsType & v;
        return ret != 0;
    }

    /**
     * 判断Item是否是档位类型
     * @return
     */
    public boolean isDegree(){
        if(TypePhonebill.equals(type)){
            return true;
        }
        if(TypeQB.equals(type)){
            return true;
        }
        if(TypeAlipay.equals(type)){
            return true;
        }
        if(TypeAlipayFast.equals(type)){
            return true;
        }
        if(TypeAlipayCode.equals(type)){
            return true;
        }
        return false;
    }

	/**
	 * 判断是否不需要库存
	 * @return
     */
	public boolean isNoStock() {
		if(TypePhonebill.equals(type)){
			return true;
		}
		if(TypePhoneflow.equals(type)){
			return true;
		}
		if(TypeQB.equals(type)){
			return true;
		}
		if(TypeAlipay.equals(type)){
			return true;
		}
		if(TypeAlipayFast.equals(type)){
			return true;
		}
		if(TypeAlipayCode.equals(type)){
			return true;
		}
		if(TypePhonebillDingzhi.equals(type)){
			return true;
		}
		return false;
	}

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getMultiImage() {
        return multiImage;
    }

    public void setMultiImage(String multiImage) {
        this.multiImage = multiImage;
    }

    public Integer getFacePrice() {
        return facePrice;
    }

    public void setFacePrice(Integer facePrice) {
        this.facePrice = facePrice;
    }

    public Integer getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(Integer marketPrice) {
        this.marketPrice = marketPrice;
    }

    public Integer getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Integer actualPrice) {
        this.actualPrice = actualPrice;
    }

	public Long getMinCredits() {
		return minCredits;
	}

	public void setMinCredits(Long minCredits) {
		this.minCredits = minCredits;
	}

	public Integer getMinFacePrice() {
		return minFacePrice;
	}

	public void setMinFacePrice(Integer minFacePrice) {
		this.minFacePrice = minFacePrice;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Boolean getSuggestDownload() {
		return suggestDownload;
	}

	public void setSuggestDownload(Boolean suggestDownload) {
		this.suggestDownload = suggestDownload;
	}

	public String getIosOpen() {
		return iosOpen;
	}

	public void setIosOpen(String iosOpen) {
		this.iosOpen = iosOpen;
	}

	public String getIosDownload() {
		return iosDownload;
	}

	public void setIosDownload(String iosDownload) {
		this.iosDownload = iosDownload;
	}

	public String getAndroidDownload() {
		return androidDownload;
	}

	public void setAndroidDownload(String androidDownload) {
		this.androidDownload = androidDownload;
	}

	public Boolean getEnable() {
		return enable;
	}

	public void setEnable(Boolean enable) {
		this.enable = enable;
	}

	public Integer getRemaining() {
		return remaining;
	}

	public void setRemaining(Integer remaining) {
		this.remaining = remaining;
	}

	public Integer getSales() {
		return sales;
	}

	public void setSales(Integer sales) {
		this.sales = sales;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public String getCustomPrice() {
		return customPrice;
	}

	public void setCustomPrice(String customPrice) {
		this.customPrice = customPrice;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public String getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(String limitScope) {
		this.limitScope = limitScope;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getTypeInt() {
		return typeInt;
	}

	public void setTypeInt(Integer typeInt) {
		this.typeInt = typeInt;
	}

	public Long getOwnerAppId() {
		return ownerAppId;
	}

	public void setOwnerAppId(Long ownerAppId) {
		this.ownerAppId = ownerAppId;
	}

	public Long getBatchId() {
		return batchId;
	}

	public void setBatchId(Long batchId) {
		this.batchId = batchId;
	}

	public Long getItemClassifyId() {
		return itemClassifyId;
	}

	public void setItemClassifyId(Long itemClassifyId) {
		this.itemClassifyId = itemClassifyId;
	}

	public Date getValidStartDate() {
		return validStartDate;
	}

	public void setValidStartDate(Date validStartDate) {
		this.validStartDate = validStartDate;
	}

	public Date getValidEndDate() {
		return validEndDate;
	}

	public void setValidEndDate(Date validEndDate) {
		this.validEndDate = validEndDate;
	}

	public Date getPublishTime() {
		return publishTime;
	}

	public void setPublishTime(Date publishTime) {
		this.publishTime = publishTime;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public String getProductPrice() {
		return productPrice;
	}

	public void setProductPrice(String productPrice) {
		this.productPrice = productPrice;
	}

	public Boolean getShutDown() {
		return shutDown;
	}

	public void setShutDown(Boolean shutDown) {
		this.shutDown = shutDown;
	}

	public Boolean getShowAlert() {
		return showAlert;
	}

	public void setShowAlert(Boolean showAlert) {
		this.showAlert = showAlert;
	}

	public String getAlertMessage() {
		return alertMessage;
	}

	public void setAlertMessage(String alertMessage) {
		this.alertMessage = alertMessage;
	}

	public Integer getDuibaType() {
		return duibaType;
	}

	public void setDuibaType(Integer duibaType) {
		this.duibaType = duibaType;
	}

	public Boolean getAutoRecommend() {
		return autoRecommend;
	}

	public void setAutoRecommend(Boolean autoRecommend) {
		this.autoRecommend = autoRecommend;
	}

	public Integer getSubType() {
		return subType;
	}

	public void setSubType(Integer subType) {
		this.subType = subType;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Integer getOperationsType() {
		return operationsType;
	}

	public void setOperationsType(Integer operationsType) {
		this.operationsType = operationsType;
	}

	public String getLimitTimeBetween() {
		return limitTimeBetween;
	}

	public void setLimitTimeBetween(String limitTimeBetween) {
		this.limitTimeBetween = limitTimeBetween;
	}

	public Integer getLimitEverydayQuantity() {
		return limitEverydayQuantity;
	}

	public void setLimitEverydayQuantity(Integer limitEverydayQuantity) {
		this.limitEverydayQuantity = limitEverydayQuantity;
	}

	public String getLimitDate() {
		return limitDate;
	}

	public void setLimitDate(String limitDate) {
		this.limitDate = limitDate;
	}

	public Integer getSourceType() {
		return sourceType;
	}

	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	public Long getSourceRelationId() {
		return sourceRelationId;
	}

	public void setSourceRelationId(Long sourceRelationId) {
		this.sourceRelationId = sourceRelationId;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public String getName4Admin() {
		return name4Admin;
	}

	public void setName4Admin(String name4Admin) {
		this.name4Admin = name4Admin;
	}

	public String getUsePrompt() {
		return usePrompt;
	}

	public void setUsePrompt(String usePrompt) {
		this.usePrompt = usePrompt;
	}

	public String getBtnText() {
		return btnText;
	}

	public void setBtnText(String btnText) {
		this.btnText = btnText;
	}

	public Long getSalePrice() {
		return salePrice;
	}

	public void setSalePrice(Long salePrice) {
		this.salePrice = salePrice;
	}

	public String getExpressType() {
		return expressType;
	}

	public void setExpressType(String expressType) {
		this.expressType = expressType;
	}

	public Long getExpressPrice() {
		return expressPrice;
	}

	public void setExpressPrice(Long expressPrice) {
		this.expressPrice = expressPrice;
	}

	public Long getExpressTemplateId() {
		return expressTemplateId;
	}

	public void setExpressTemplateId(Long expressTemplateId) {
		this.expressTemplateId = expressTemplateId;
	}

	public Integer getStockWarnValue() {
		return stockWarnValue;
	}

	public void setStockWarnValue(Integer stockWarnValue) {
		this.stockWarnValue = stockWarnValue;
	}

	public Long getSellerId() {
		return sellerId;
	}

	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public String getSellerName() {
		return sellerName;
	}

	public void setSellerName(String sellerName) {
		this.sellerName = sellerName;
	}

	public Long getAdminId() {
		return adminId;
	}

	public void setAdminId(Long adminId) {
		this.adminId = adminId;
	}

	public Integer getImmediatelyButton() {
		return immediatelyButton;
	}

	public void setImmediatelyButton(Integer immediatelyButton) {
		this.immediatelyButton = immediatelyButton;
	}

	public String getExchangeTipTemplate() {
		return exchangeTipTemplate;
	}

	public void setExchangeTipTemplate(String exchangeTipTemplate) {
		this.exchangeTipTemplate = exchangeTipTemplate;
	}

    public ItemExtraDto getItemExtraDto() {
        return itemExtraDto;
    }

    public void setItemExtraDto(ItemExtraDto itemExtraDto) {
        this.itemExtraDto = itemExtraDto;
    }

    public Long getStockId() {
        return stockId;
    }

    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public ItemDescConfigDto getItemDescConfigDto() {
        return itemDescConfigDto;
    }

    public void setItemDescConfigDto(ItemDescConfigDto itemDescConfigDto) {
        this.itemDescConfigDto = itemDescConfigDto;
    }

    public ItemLimitConfigDto getItemLimitConfigDto() {
        return itemLimitConfigDto;
    }

    public void setItemLimitConfigDto(ItemLimitConfigDto itemLimitConfigDto) {
        this.itemLimitConfigDto = itemLimitConfigDto;
    }

    public List<ItemSkuDto> getItemSkuDtoList() {
        return itemSkuDtoList;
    }

    public void setItemSkuDtoList(List<ItemSkuDto> itemSkuDtoList) {
        this.itemSkuDtoList = itemSkuDtoList;
    }

    public Boolean getEnableTypeActivity() {
        return isOpTypeItem(super.OpTypeActivity);
    }

    public Boolean getEnableTypeDiscountGoods() {
        return isOpTypeItem(super.OpTypeDiscountGoods);
    }

    public Boolean getEnableTypeSpecify() {
        return isOpTypeItem(super.OpTypeSpecify);
    }

    public Boolean getEnableTypeDevBlacklist() {
        return isOpTypeItem(super.OpTypeDevBlacklist);
    }

    public Boolean getEnableTypePreStockSwith() {
        return isOpTypeItem(super.OpTypePreStockSwith);
    }

	public Boolean getMultiSku() {
		return multiSku;
	}

	public void setMultiSku(Boolean multiSku) {
		this.multiSku = multiSku;
	}

	public Long getDistributorId() {
		return distributorId;
	}

	public void setDistributorId(Long distributorId) {
		this.distributorId = distributorId;
	}

	public String getMerchantCoding() {
		return merchantCoding;
	}

	public void setMerchantCoding(String merchantCoding) {
		this.merchantCoding = merchantCoding;
	}

	public ItemPriceDto getItemPriceDto() {
		return itemPriceDto;
	}

	public void setItemPriceDto(ItemPriceDto itemPriceDto) {
		this.itemPriceDto = itemPriceDto;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
