package cn.com.duiba.goods.center.api.remoteservice.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 随机红包类型枚举
 */
public enum RandomRewardTypeEnum {

    GLOBAL_REWARD(0, "全局红包"),
    HAND_REWARD(1, "手气红包"),
    PET_FOOD(2, "宠物养成粮食"),
    GUESS_REWARD(3, "猜红包"),
    TOTAL_REWARD(4, "累计红包")
    ;

    private static final ImmutableMap<Integer, RandomRewardTypeEnum> ALL_MAP;

    static {
        Map<Integer, RandomRewardTypeEnum> temp = Maps.newHashMap();
        for (RandomRewardTypeEnum type : values()) {
            temp.put(type.getCode(), type);
        }
        ALL_MAP = ImmutableMap.copyOf(temp);
    }

    /** 类型代码 */
    private Integer code;
    /** 描述 */
    private String desc;

    RandomRewardTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static RandomRewardTypeEnum getByCode(Integer code) {
        return ALL_MAP.get(code);
    }

}
