package cn.com.duiba.goods.center.api.remoteservice.model;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.model.CategoryAttrValDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.model.GoodsItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.model.GoodsItemSkuConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.model.ItemAttrValConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.model.SkuConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.GoodsItemSourceType;

import java.util.List;

/**
 * 商品模型接口，提供：属性、规格、sku等标准商品模型接入服务
 * Created by xiaoxuda on 2018/7/31.
 */
@AdvancedFeignClient
public interface RemoteGoodsModelService {
    /**
     * 根据叶子类目Id查询对应类目下的所有属性及属性值
     * @param categoryId
     * @return
     */
    List<CategoryAttrValDto> findAttrByCategory(Long categoryId);

    /**
     * 加入商品模型
     * @param type 渠道类型
     * @param itemId 商品ID
     * @return 标准商品ID
     */
    Long joinGoodsModel(Long categoryId, GoodsItemSourceType type, Long itemId);

    /**
     * 根据渠道与ID反查标准商品信息
     * @param type
     * @param itemId
     * @return
     */
    GoodsItemDto findByTypeAndId(GoodsItemSourceType type, Long itemId);

    /**
     * 根据渠道与ID反查标准商品信息
     * @param type
     * @param itemIds
     * @return
     */
    List<GoodsItemDto> batchFindByTypeAndIds(GoodsItemSourceType type, List<Long> itemIds);

    /**
     * 保存商品属性配置
     * @param param
     * @return
     */
    boolean saveItemAttrVal(ItemAttrValConfigDto param);

    /**
     * 根据标准商品ID查询商品属性配置
     * @param goodsItemId
     * @return
     */
    ItemAttrValConfigDto findItemAttrValConfigDto(Long goodsItemId);

    /**
     * 商品SKU查询
     * @param goodsItemId
     * @return
     */
    GoodsItemSkuConfigDto findGoodsItemSku(Long goodsItemId);

    /**
     * 批量查询
     * @param goodsItemIds
     * @return
     */
    List<GoodsItemSkuConfigDto> batchFindGoodsItemSku(List<Long> goodsItemIds);

    /**
     * 保存商品sku
     * @param param
     * @return
     */
    boolean saveGoodsItemSku(GoodsItemSkuConfigDto param);

    /**
     * 更新商品与sku销量统计
     * @param goodsItemId
     * @param skuId
     * @param modify
     * @return
     */
    boolean updateSaleCount(Long goodsItemId, Long skuId, Integer modify);

    /**
     * 根据类目、数据来源及属性值查询商品ID
     * @param categoryId
     * @param type
     * @param attrValIds
     * @return
     */
    List<Long> batchFindItemIdByCategoryAndTypeAndAttrVal(Long categoryId, GoodsItemSourceType type, List<Long> attrValIds);

    /**
     * 根据类目、数据来源查询商品ID
     * @param categoryId
     * @param type
     * @return
     */
    List<Long> batchFindItemIdByCategoryAndType(Long categoryId, GoodsItemSourceType type);

    /**
     * 通过skuId查询sku信息，包含属性值配置
     * @param skuId
     * @return
     */
    SkuConfigDto findById(Long skuId);
    /**
     * 通过skuIds查询sku信息，包含属性值配置
     * @param skuIds
     * @return
     */
    List<SkuConfigDto> findByIds(List<Long> skuIds);
}
