package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemClassifyDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * Created by xutao on 2017/9/19.
 */
@AdvancedFeignClient
public interface RemoteItemClassifyBackendService {

    /**
     * 根据type查询列表
     */
    DubboResult<List<ItemClassifyDto>> findAllByType(String type);

    /**
     * 删除
     */
    DubboResult<Integer> delete(Long id);

    /**
     * 根据ids in
     */
    DubboResult<List<ItemClassifyDto>> findAllByIds(List<Long> ids);

    /**
     * 分页列表
     */
    public Page<ItemClassifyDto> findItemClassifyPage(Map<String, Object> queryMap) ;

    /**
     * 创建
     */
    public ItemClassifyDto createByNameAndType(String name, String type) ;

    /**
     * 更新
     */
    public ItemClassifyDto updateByNameAndId(String name, Long id) ;

    /**
     * 多类型查询
     * @param typeList
     * @return
     */
    List<ItemClassifyDto> findAllByTypeList(List<String> typeList);

    /**
     * 更新分类的费率
     * @param id
     * @param rate
     * @return
     */
    public Integer updateClassifyRate(Long id, Long rate);
}
